var fs=require("fs");
var settings=require("../settings");
var glob = require("glob");
var system = require('../../base/system');

module.exports = function (app) {
	app.get('/vue/comp/base',function(req,res){
		var vuePath=settings.basepath+"/app/front/vues/base";
		var baseComps=[];
		var rs=glob.sync(vuePath+"/**/*.vue");
		if(rs){
			rs.forEach(function(r){
				var comp="";
				if(settings.env=="dev"){
					 delete require.cache[r];
					 comp=require(r).replace(/\n/g,"");
				}else{
					 comp=require(r).replace(/\n/g,"");
				}
				baseComps.push(comp);
			});
			res.end(JSON.stringify(baseComps));
		}
	});
	app.get('/vue/comp/:cname',function(req,res){
		var componentName=req.params.cname;
		var theme=req.headers["theme"];
		var hostname=req.hostname;
		buildComponent(componentName,theme,hostname).then(function(r){
			res.end(escape(r.replace(/\n/g,"")));
			// res.end(r);
		});
	});
};
