const system = require("../system");
const settings = require("../../config/settings");
const uuidv4 = require('uuid/v4');
const sha256 = require('sha256');
const md5 = require("MD5");

class APIBase {
    constructor() {
        this.execClientNew = system.getObject("util.execClientNew");
        this.restClient = system.getObject("util.restClient");
        this.redisClient = system.getObject("util.redisClient");
        this.cacheManager = system.getObject("db.common.cacheManager");
        this.logCtl = system.getObject("service.common.oplogSve");
        this.toolSve = system.getObject("service.trademark.toolSve");
        this.exTime = 6 * 3600;//缓存过期时间，6小时
        this.cacheMethodList = [
            "icpNotify"
        ];
    }

    getUUID() {
        var uuid = uuidv4();
        var u = uuid.replace(/\-/g, "");
        return u;
    }

    //-----------------------新的模式------------------开始

    async doexecMethod(gname, methodname, pobj, query, req) {
        req.requestId = this.getUUID();
        try {
            var shaStr = await sha256(JSON.stringify(pobj));
            //查询缓存
            var cacheRes = await this.redisClient.get(shaStr);
            if (cacheRes) {
                return JSON.parse(cacheRes);
            }
            var result = await this[methodname](pobj, query, req);
            if (result && !result.requestId) {
                result.requestId = pobj.RequestId ? pobj.RequestId : pobj.requestId || req.requestId;
            }
            this.logCtl.createDb({
                appid: req.app.id,
                appkey: req.app.uappKey,
                requestId: req.requestId,
                op: req.classname + "/" + methodname,
                content: JSON.stringify(pobj),
                resultInfo: JSON.stringify(result),
                clientIp: req.clientIp,
                agent: req.uagent,
                opTitle: "api服务提供方appKey:" + settings.appKey,
            });
            if (this.cacheMethodList.indexOf(methodname) >= 0 && result.status && result.status == 0) {
                //保存缓存
                await this.redisClient.setWithEx(shaStr, JSON.stringify(result), 3600);
            }
            var tmpResult = pobj.actionType && pobj.actionType.indexOf("List") < 0 ? result : {
                status: result.status,
                message: result.message,
                requestId: result.requestId
            };
            this.execClientNew.execLogs("api-center-channel-doexecMethod-reqPath:" + req.path, pobj, "center-channel-doexecMethod", tmpResult, null);
            return result;
        } catch (e) {
            const stackStr = e.stack ? e.stack : JSON.stringify(e);
            console.log(stackStr, "api调用出现异常，请联系管理员..........");
            this.logCtl.createDb({
                appid: req.app.id,
                appkey: req.app.uappKey,
                requestId: req.requestId,
                op: req.classname + "/" + methodname,
                content: JSON.stringify(pobj),
                resultInfo: stackStr,
                clientIp: req.clientIp,
                agent: req.uagent,
                opTitle: "api调用出现异常，请联系管理员error，appKey:" + settings.appKey,
            });
            // this.logCtl.error({
            //     appid: req.app.id,
            //     appkey: req.app.uappKey,
            //     requestId: req.requestId,
            //     op: req.classname + "/" + methodname,
            //     content: e.stack,
            //     clientIp: pobj.clientIp,
            //     agent: req.uagent,
            //     optitle: "api调用出现异常，请联系管理员",
            // });
            this.execClientNew.execLogs("center-channel-doexecMethod-reqPath异常:" + req.path, pobj, "center-channel-doexecMethod", null, stackStr);
            var rtnerror = system.getResultFail(-200, "出现异常，error：" + stackStr);
            rtnerror.requestId = req.requestId;
            return rtnerror;
        }
    }

    //-----------------------新的模式------------------结束

    async restPostUrl(pobj, url) {
        var rtn = await this.restClient.execPost(pobj, url);
        if (!rtn || !rtn.stdout) {
            return system.getResult(null, "restPost data is empty");
        }
        var result = JSON.parse(rtn.stdout);
        return result;
    }

    /**
     * 带超时时间的post请求
     * @param {*} req 请求信息
     * @param {*} params 请求数据-json格式
     * @param {*} url 请求地址
     * @param {*} ContentType 请求头类型，默认application/json
     * @param {*} headData 请求头内容-json格式，如：请求头中传递token,格式：{token:"9098902q849q0434q09439"}
     * @param {*} timeOut 超时时间
     */
    async execPostByTimeOut(req, params, url, ContentType, headData, timeOut = 60) {
        const result = await this.execClientNew.execPostTimeOutByBusiness('sve.base', params, url, ContentType, headData, timeOut, req);
        return result;
    }

    /**
     * 带headData和超时时间的post请求
     * @param {*} params 请求数据-json格式
     * @param {*} url 请求地址
     * @param {*} ContentType 请求头类型，默认application/json
     * @param {*} headData 请求头内容-json格式，如：请求头中传递token,格式：{token:"9098902q849q0434q09439"}
     * @param {*} timeOut 超时时间
     */
    async execPostByHeadDataTimeOut(params, url, ContentType, headData, timeOut = 5000) {
        const result = await this.execClientNew.execPost(params, url, ContentType, headData, timeOut);
        return result;
    }
}

module.exports = APIBase;

// var tmpapi=new APIBase();
// tmpapi.execPostByHeadDataTimeOut({"name":"sytest"},"http://qq.com",null,{"ak":"testak"},60)
