var WEBBase = require("../../web.base");
var system = require("../../../system");
const logCtl = system.getObject("service.common.oplogSve");

class opLog extends WEBBase {
    constructor() {
        super();
        this.pushlogSve = system.getObject("service.common.pushlogSve");
    }
    async info(pobj, qobj, req) {
        this.logCtl.info(pobj);
    }
    async error(pobj, qobj, req) {
        this.logCtl.error(pobj);
    }

    /**
     * 获取channel推送失败日志列表
     * @param pobj
     * @param qobj
     * @param req
     * @returns {Promise<void>}
     */
    async getPushFailLogList(pobj,qobj,req){
        let list = await this.pushlogSve.getPushFailLogList(pobj.actionBody);
        return list;
    }

    /**
     * channel重新推送
     * @param pobj
     * @param qobj
     * @param req
     * @returns {Promise<void>}
     */
    async rePush(pobj,qobj,req){
        let result = await this.pushlogSve.rePush(pobj.actionBody);
        return result;
    }

    /**
     * 获取gateway推送失败日志列表
     * @param pobj
     * @param qobj
     * @param req
     * @returns {Promise<void>}
     */
     async getGatewayPushFailLogList(pobj,qobj,req){
        let list = await this.pushlogSve.getGatewayPushFailLogList(pobj.actionBody);
        return list;
    }

    /**
     * gateway重新推送
     * @param pobj
     * @param qobj
     * @param req
     * @returns {Promise<void>}
     */
    async reGatewayPush(pobj,qobj,req){
        let result = await this.pushlogSve.reGatewayPush(pobj.actionBody);
        return result;
    }
}
module.exports = opLog;