var APIBase = require("../../api.base");
var system = require("../../../system");
var settings = require("../../../../config/settings");
const uuidv4 = require('uuid/v4');
/**
 * 商标需求
 * 庄冰 2021.03.17
 */
class Consultation extends APIBase {
    constructor() {
        super();
        this.gatewaypushlogSve = system.getObject("service.common.gatewaypushlogSve");
    }

    getUUID() {
        var uuid = uuidv4();
        var u = uuid.replace(/\-/g, "");
        return u;
    }
    getResultSuccess(requestId) {
        return {
        "status": 0,
        "msg": "success",
        "data":null,
        "requestId": requestId
        };
    }
    getResultFail(errmsg) {
        var self = this;
        return {
        "status":-1,
        "msg": errmsg,
        "requestId": self.getUUID(),
        "data":null,
        "bizmsg":"empty"
        };
    }

    //需求提交
    async submit(pobj,obj,req) {
        var self = this;
        if(!pobj.appInfo || !pobj.appInfo.uapp_key || !pobj.appInfo.uapp_secret){
            return self.getResultFail("未知应用或应用未启用");
        }
        if (!pobj.intentionBizId) {
            return self.getResultFail("intentionBizId不能为空");
        }
        if (!pobj.phone) {
            return self.getResultFail("phone不能为空");
        }
        if (!pobj.consultType) {
            return self.getResultFail("consultType不能为空");
        }
        
        pobj.type = pobj.consultType;
        pobj.mobile = pobj.phone;
        pobj.action_type = "submitTmNeed";
        var param = {
            requestId: req.requestId || self.getUUID(),
            requestUrl: pobj.appInfo.app_code+"/tm/consultation/submit",
            requestjson: JSON.stringify(pobj),//请求地址
            pushUrl: "/action/intentionapi/springBoard",//调用地址
            pushActionType: "submitTmNeed",//调用参数
            pushtimes: 0,//推送次数
            pushStatus: "wts",//推送状态
        }
        await self.gatewaypushlogSve.create(param);
        return self.getResultSuccess(param.requestId);
    }

    /**
     * 需求关闭CloseTradeMarkProduct
     * @param {*} pobj 
     * @param {*} obj 
     * @param {*} req 
     */
    async close(pobj,obj,req){
        if (!pobj.IntentionBizId) {
            return self.getResultFail("IntentionBizId不能为空");
        }
        var reqUrl = settings.centerOrderUrl() + "action/opNeed/springBoard";
        var reqObj={
            actionType:"opNeedClose",
            actionBody:{needNo:pobj.IntentionBizId},
            appInfo:pobj.appInfo
        }
        var result = await this.utilsNeedSve.restPostUrl(reqObj,reqUrl);
        return result;
    }

}
module.exports = Consultation;