const CacheBase=require("../cache.base");
const system=require("../../system");
// const OpenplatformWxop =  require("../../wxop/impl/openplatformWxop");
/**
 * 飞书小程序--AppAccessToken缓存--有效时间7100s
 */
class feishuAppAccessTokenCache extends CacheBase{
   constructor(){
     super();
     this.restClient = system.getObject("util.restClient");
     this.prefix="feishu_appAccessToken_9e28dcb1d637100d";
   }
    desc() {
        return "应用UI配置缓存";
    }
    prefix() {
        return "feishu_appAccessToken_9e28dcb1d637100d";
    }
   async get(){
      var key = this.prefix;
      var result = await this.redisClient.get(key);
      return result;
   }
   async set(accessToken,expire){
      if(!expire){
         expire=7100;
      }
      var key = this.prefix;
      if(accessToken){
         await this.redisClient.setWithEx(key,accessToken,expire);
      }
      return accessToken;
   }
}
module.exports=feishuAppAccessTokenCache;