const CacheBase = require("../cache.base");
const system = require("../../system");
const settings = require("../../../config/settings");
class TlPayLocker extends CacheBase {
  constructor() {
    super();
    this.prefix = settings.cacheprefix + "_tlPayLocker:";
  }
  desc() {
    return "支付业务锁";
  }
  prefix() {
    return settings.cacheprefix + "_uiconfig:";
  }

  async init(tradekey) {
    const key = this.prefix + tradekey;
    return this.redisClient.rpushWithEx(key, "1", 1800);
  }
  async enter(tradekey) {
    const key = this.prefix + tradekey;
    return this.redisClient.rpop(key);
  }
  async release(tradekey) {
    const key = this.prefix + tradekey;
    return this.redisClient.rpushWithEx(key, "1", 1800);
  }
}
module.exports = TlPayLocker;
