const system = require("../../../system");
const settings = require("../../../../config/settings");
const uiconfig = system.getUiConfig2(settings.appKey);
module.exports = (db, DataTypes) => {
    return db.define("gatewaypushlog", {
        requestId: DataTypes.STRING,
        requestUrl: DataTypes.STRING, //请求地址
        requestjson: DataTypes.STRING,//请求地址
        pushUrl: DataTypes.STRING,//调用地址
        pushActionType: DataTypes.STRING,//调用参数
        pushtimes: DataTypes.INTEGER,//推送次数
        pushStatus: DataTypes.STRING,//推送状态
        error: DataTypes.STRING(5000),//错误信息
        interface_path: DataTypes.STRING(1024),//接口路径
        interface_method: DataTypes.STRING,//接口方法
    }, {
        paranoid: false,//假的删除
        underscored: true,
        version: true,
        freezeTableName: true,
        timestamps: true,
        updatedAt: false,
        //freezeTableName: true,
        // define the table's name
        tableName: 'gateway_pushlog',
        validate: {},
        indexes: [
            // Create a unique index on email
            //  {
            //    unique: true,
            //    fields: ['email']
            //  },
            //
            //  // Creates a gin index on data with the jsonb_path_ops operator
            //  {
            //    fields: ['data'],
            //    using: 'gin',
            //    operator: 'jsonb_path_ops'
            //  },
            //
            //  // By default index name will be [table]_[fields]
            //  // Creates a multi column partial index
            //  {
            //    name: 'public_by_author',
            //    fields: ['author', 'status'],
            //    where: {
            //      status: 'public'
            //    }
            //  },
            //
            //  // A BTREE index with a ordered field
            //  {
            //    name: 'title_index',
            //    method: 'BTREE',
            //    fields: ['author', {attribute: 'title', collate: 'en_US', order: 'DESC', length: 5}]
            //  }
        ]
    });
}
