const system = require("../../../system");
const settings = require("../../../../config/settings");
const AppServiceBase = require("../../app.base");

//不要在此类中增加新的方法
class UtilsPushService extends AppServiceBase {
    constructor() {
        super();
    };

    async business2Channel(pobj, opType) {//供业务调用，在代码中调用，不在db中做配置进行调用，适用所有渠道推送
        pobj.actionType = "getAppInterface";
        let reqUrl = settings.centerAppUrl() + "action/opProduct/springBoard";
        let productItemInterfaceResult = await this.restPostUrl(pobj, reqUrl);
        pobj.interface_info = productItemInterfaceResult.data;
        //日志记录
        this.execClientNew.execLogs(`${opType}推送蜂擎获取的接口信息->business2Channel->app(getAppInterface)`, pobj, "center-channel-utilsPushSve-business2Channel", productItemInterfaceResult.data, null);
        if (pobj.interface_info && pobj.interface_info.length > 0) {
            let tmpResult = await this.pushBusInfo(pobj, opType, 1);
            return system.getResultSuccess(tmpResult);
        }
        return system.getResult(null, "push Fail，interface_info　data is empty");
    }

    async pushBusInfo(pobj, opType, isDelProductInfo) {//推送业务总入口，不在db中做配置进行调用
        console.log(JSON.stringify(pobj), ".......pushBusInfo........................." + opType);
        var interface_list = pobj.interface_info ? pobj.interface_info : pobj.actionBody.product_info.interface_info;
        if (!interface_list) {
            return system.getResult(null, "暂无推送配置");
        }
        var interface_list_temp = interface_list.filter(f => f.op_type == opType);
        // console.log(interface_list_temp, "interface_list_temp+++++++++++++++");
        if (!interface_list_temp || interface_list_temp.length == 0) {
            return system.getResult(null, "暂无【" + opType + "】的推送配置");
        }
        var self = this;
        let result;
        if (interface_list_temp && interface_list_temp.length == 1) {
            const element = interface_list_temp[0];
            let reflexActionRes = await self.reflexAction(element, opType, pobj, isDelProductInfo);
            self.execClientNew.execLogs("utilsPushSve-pushBusInfo-result11:", pobj, "center-channel-reflexAction", reflexActionRes, null);
            return reflexActionRes;
        } else {
            for (let index = 0; index < interface_list_temp.length; index++) {
                const element = interface_list_temp[index];
                result = await self.reflexAction(element, opType, pobj, isDelProductInfo);
                self.execClientNew.execLogs("utilsPushSve-pushBusInfo-result22:", pobj, "center-channel-reflexAction", result, null);
            }
            return result;
        }

    }

    async againPushBusInfo(pobj) {//再次推送业务总入口-重试
        var interface_info = pobj.interface_info ? pobj.interface_info : pobj.actionBody.product_info.interface_info;
        if (!interface_info) {
            return system.getResult(null, "暂无推送配置");
        }
        var result = await this.reflexAction(interface_info, pobj.opType, pobj, pobj.isDelProductInfo || 1);
        this.execClientNew.execLogs("againPushBusInfo-reflexAction-result:", pobj, "center-channel-reflexAction", result, null);
        if (result.status != 0) {
            return result;
        }
        return system.getResultSuccess();
    }

    async reflexAction(interface_info, opType, pobj, isDelProductInfo) {
        console.log(`pobj=${JSON.stringify(pobj)}，interface_info=${JSON.stringify(interface_info)}`, `reflexAction.......opType=${opType}`);
        var refResult = null;
        pobj.interface_info = interface_info;
        pobj.opType = opType;
        pobj.isDelProductInfo = isDelProductInfo;
        try {
            if (interface_info.interface_type == "bd") {
                if (!interface_info.method_name) {
                    return system.getResult(null, "接口对应的method_name参数信息为空，100350");
                }//操作的方法名称
                var invokeObj = system.getObject(interface_info.interface_url);
                if (!invokeObj[interface_info.method_name]) {
                    return system.getResult(null, "接口对应的method_name参数方法信息有误，100360");
                }
                pobj.interface_params = interface_info.params;
                var params = [pobj];
                var doRes = await invokeObj[interface_info.method_name].apply(invokeObj, params);
                return doRes;
            } else if (interface_info.interface_type == "yc") {
                var actionBody = pobj.actionBody;
                if (!interface_info.interface_url) {
                    return system.getResult(null, "产品接口interface_url参数不能为空，100370");
                }
                if (actionBody.product_info && actionBody.product_info.price_list) {
                    delete actionBody.product_info["price_list"];
                }
                if (actionBody.product_info && actionBody.product_info.interface_info) {
                    delete actionBody.product_info["interface_info"];
                }
                if (isDelProductInfo && isDelProductInfo == 1 && actionBody.product_info) {
                    delete actionBody["product_info"];
                }//是否删除产品信息进行推送
                refResult = await this.restPostUrl(pobj.actionBody, interface_info.interface_url);
                if (refResult.code == 1) {
                    refResult.status = 0
                }
                this.disposePushResult(pobj, refResult, "ycUrlPush->reflexAction->refResult", this.pushlogFailType.NEWRPC);
            }
            return system.getResultSuccess();
        } catch (e) {
            var errorResult = system.getResult(null, "送异常-->reflexAction->" + e.stack)
            return await this.disposePushResultFail(pobj, errorResult, "数据推送异常-->reflexAction-->errorResult", this.pushlogFailType.FAILLOG);
        }
    }

}

module.exports = UtilsPushService;
