var APIBase = require("../../api.base");
var system = require("../../../system");
var settings = require("../../../../config/settings");
class OpProductAPI extends APIBase {
    constructor() {
        super();
        this.productSve = system.getObject("service.dbproduct.productSve");
        this.producttypeSve = system.getObject("service.dbproduct.producttypeSve");
    }
    /**
      * 接口跳转-POST请求
      * action_process  执行的流程
      * action_type     执行的类型
      * action_body     执行的参数
      */
    async springBoard(pobj, qobj, req) {
        if (!pobj.actionType) {
            return system.getResult(null, "actionType参数不能为空");
        }
        var result = await this.opActionProcess(pobj, pobj.actionType, req);
        return result;
    }
    async opActionProcess(pobj, action_type, req) {
        var opResult = null;
        switch (action_type) {
            case "getProductList"://通过产品类别编码获取产品列表
                opResult = await this.productSve.getProductList(pobj.actionBody, pobj.appInfo);
                break;
            case "getProductDetail"://获取产品详情
                opResult = await this.productSve.getProductDetail(pobj.actionBody, pobj.appInfo);
                break;
            case "getProductInterface"://获取产品接口信息
                opResult = await this.productSve.getProductInterface(pobj, pobj.actionBody);
                break;
            case "getAppInterface"://获取应用接口信息
                opResult = await this.productSve.getAppInterface(pobj, pobj.actionBody);
                break;
            case "getaliicProduce"://阿里工商获取产品信息
                opResult = await this.productSve.getaliicProduce(pobj.actionBody);
                break;
            case "getaliicpProduce"://阿里icp获取产品信息
                opResult = await this.productSve.getaliicpProduce(pobj.actionBody,pobj.appInfo);
                break;
            case "getIcpProduce"://获取ICP产品信息
                opResult = await this.productSve.getIcpProduce(pobj.actionBody,pobj.appInfo);
                break;
            case "getProductTypeInfo"://阿里工商获取需求類型
                opResult = await this.producttypeSve.getProductTypeInfo(pobj.actionBody, pobj.appInfo);
                break;
            case "getProductPrice"://询价
                opResult = await this.productSve.getProductPrice(pobj.actionBody);
                break;
            case "getMinPrice"://最低价
                opResult = await this.productSve.getMinPrice(pobj);
                break;
            case "getProductRecommend":
                opResult = await this.productSve.getProductRecommend(pobj.actionBody,pobj.appInfo);
                break;
            case "updateProductPrice":
                opResult = await this.productSve.updateProductPrice(pobj.actionBody,pobj.appInfo);
                break;
            //2020-12-17  baidu reg start -----------------
            case "getRegProducePrice"://获取reg产品price
                opResult = await this.productSve.getRegProducePrice(pobj.actionBody);
                break;

            //2020-12-17  baidu reg end -----------------
            case "getAllProducts":
                opResult = await this.productSve.getAllProducts();
                break;
            case "getProductByWhere":
                opResult = await this.productSve.getProductByWhere(pobj.actionBody);
                break;
            case "getymicpProduce"://易名icp获取产品信息
                opResult = await this.productSve.getymicpProduce(pobj.actionBody,pobj.appInfo);
                break;
            case "getAllPathName":
                opResult = await this.productSve.getAllPathName();
                break;
            default:
                opResult = system.getResult(null, "action_type参数错误");
                break;
        }
        return opResult;
    }


}
module.exports = OpProductAPI;
