const CacheBase = require("../cache.base");
const system = require("../../system");
const settings = require("../../../config/settings");
class AppTokenByHostsCache extends CacheBase {
  constructor() {
    super();
    this.opPlatformUtils = system.getObject("util.businessManager.opPlatformUtils");
    this.restS = system.getObject("util.restClient");
    this.appDao = system.getObject("db.dbapp.appDao");
  }
  desc() {
    return "应用中缓存访问token";
  }
  prefix() {
    return settings.cacheprefix + "_accesskey:";
  }
  //优化掉从平台中获取应用信息--sy-2020-10-21
  async buildCacheVal(cachekey, inputkey, val, ex, ...items) {
    var actionBody = val;
    if (!actionBody) {
      return system.getResult(null, "actionBody can not be empty ！");
    }
    var item = null;
    if (actionBody.reqType == "hosts") {
      item = await this.appDao.getItemByHosts(actionBody.appHosts);
    }
    if (actionBody.reqType == "appkey") {
      item = await this.appDao.getItemByAppKey(actionBody.appkey, actionBody.secret);
    }
    if (!item) {
      return system.getResult(null, "app_hosts to data is empty ！");
    }
    if (item.is_enabled != 1) {
      return system.getResult(null, "app_hosts to item is Disable ！");
    }
    // if (!item.uapp_key || !item.uapp_secret) {
    //   return system.getResult(null, "uapp_key or uapp_secret can not be empty ！");
    // }
    // var result = await this.opPlatformUtils.getReqApiAccessKey(item.uapp_key, item.uapp_secret);
    // if (!result) {
    //   return system.getResult(null, "platform to data is empty ！");
    // }
    // if (result.status != 0) {
    //   return result;
    // }
    // item.token = result.data.accessKey;
    return system.getResultSuccess(item);
  }
}
module.exports = AppTokenByHostsCache;
