const CacheBase = require("../cache.base");
const system = require("../../system");
const settings = require("../../../config/settings");
class AppUserPinByLoginPwdCache extends CacheBase {
  constructor() {
    super();
    this.opPlatformUtils = system.getObject("util.businessManager.opPlatformUtils");
    this.appuserDao = system.getObject("db.dbapp.appuserDao");
  }
  desc() {
    return "应用中缓存访问token";
  }
  prefix() {
    return settings.cacheprefix + "_userPin:";
  }
  //优化掉从平台中获取应用信息--sy-2020-10-21
  async buildCacheVal(cachekey, inputkey, val, ex, ...items) {
    const actionBody = val.actionBody;
    const appInfo = val.appInfo;
    const uUserName = actionBody.userName;//uUserName
    const password = await this.getEncryptStr(actionBody.password);//uPassword    
    // var uUserInfo = await this.opPlatformUtils.login(uUserName, uPassword,
    //   appInfo.uapp_key, appInfo.uapp_secret);
    // if (uUserInfo.status != 0) {
    //   return uUserInfo;
    // }//值为2010为用户名或密码错误
    var userInfo = await this.appuserDao.getItemByPwd(uUserName, password, appInfo.uapp_id);
    if (!userInfo) {
      return system.getResult(null, "user to item is empty ！");
    }
    if (userInfo.is_enabled != 1) {
      return system.getResult(null, "user to item is Disable ！");
    }
    return system.getResultSuccess(userInfo);
  }
}
module.exports = AppUserPinByLoginPwdCache;
