const CacheBase = require("../cache.base");
const system = require("../../system");
const settings = require("../../../config/settings");
class AppUserPinByLoginVcodeCache extends CacheBase {
  constructor() {
    super();
    this.opPlatformUtils = system.getObject("util.businessManager.opPlatformUtils");
    this.appuserDao = system.getObject("db.dbapp.appuserDao");
  }
  desc() {
    return "应用中缓存访问token";
  }
  prefix() {
    return settings.cacheprefix + "_userPin:";
  }
  async buildCacheVal(cachekey, inputkey, val, ex, ...items) {
    let actionBody = val.actionBody;
    let appInfo = val.appInfo;
    let userInfo = await this.appuserDao.getItemByMobile(actionBody.mobile, appInfo.uapp_id);
    if (userInfo) {
      if (userInfo.is_enabled != 1) {
        return system.getResult(null, "用户未启用");
      }
      if (actionBody.reqType === "reg") {
        return system.getResult(null, "已经存在此用户，注册失败");
      }
      return system.getResultSuccess(userInfo);
    }

    const uPassword = await this.getEncryptStr((actionBody.password || actionBody.mobile));//uPassword   
    let params = {
      uapp_id: appInfo.uapp_id,
      channel_userid: actionBody.mobile || "",
      channel_username: actionBody.mobile || "",
      channel_nickname: actionBody.nickName || "",
      mobile: actionBody.mobile || "",
      password: uPassword,
      org_name: actionBody.orgName || "",
      org_path: actionBody.orgPath || "",
      is_enabled: 1,
      email: actionBody.email || "",
      last_login_time: new Date()
    };
    userInfo = await this.appuserDao.create(params);
    params.password = "";
    return system.getResultSuccess(params);
  }
}
module.exports = AppUserPinByLoginVcodeCache;
