const CacheBase = require("../cache.base");
const system = require("../../system");
const settings = require("../../../config/settings");
//缓存首次登录的赠送的宝币数量
class VCodeCache extends CacheBase {
  constructor() {
    super();
    this.smsUtil = system.getObject("util.smsClient");
  }
  // isdebug() {
  //   return settings.env == "dev";
  // }
  desc() {
    return "缓存给手机发送的验证码60妙";
  }
  prefix() {
    return settings.cacheprefix + "g_vcode:appkey_";
  }
  async buildCacheVal(cachekey, inputkey, val, ex, ...items) {
    //【XXX】您的验证码是：602639（5分钟内有效），工作人员不会索取，请勿泄露。-------描述在模板中配置
    var params = val;
    var vcode = await this.smsUtil.getUidStr(6, 10);
    if (params && params.reqType) {
      switch (params.reqType) {
        case "defaultVcode":
          const msg = "您的验证码：" + vcode + "，请在60秒输入完成验证，若非本人操作，请勿泄露"
          this.smsUtil.sendDefaultVcodeMsg(params.mobile, msg);
          break;
        case "defaultOtherVcode"://暂时没有用到
          this.smsUtil.aliSendMsg(params.mobile, params.tmplCode, params.signName, JSON.stringify({ code: vcode }));
          break;
        case "otherVcode":
          this.smsUtil.aliOtherSendMsg(params.mobile, params.accessKeyId, params.accessKeySecret, params.tmplCode,
            params.signName, JSON.stringify({ code: vcode }));
          break;
        default:
          break;
      }
    }
    return system.getResultSuccess({ vcode: vcode });
  }
}
module.exports = VCodeCache;
