const system = require("../../../system");
const Dao = require("../../dao.base");
class AppuserDao extends Dao {
  constructor() {
    super(Dao.getModelName(AppuserDao));
  }
  /**
   * 通过渠道用户唯一码进行登录
   * @param {*} channel_userid 
   * @param {*} uapp_id 
   */
  async getItemByChannelUserId(channel_userid, uapp_id) {
    return this.model.findOne({
      where: {
        channel_userid: channel_userid,
        uapp_id: uapp_id
      },
      attributes: ["id",
        "uapp_id",
        "channel_userid",
        "channel_username",
        "channel_nickname",
        "open_id",
        "head_url",
        "mobile",
        "org_name",
        "org_path",
        "email",
        "is_admin",
        "is_super",
        "is_enabled"],
      raw: true
    });
  }
  /**
   * 通过密码进行登录
   * @param {*} channel_userid 
   * @param {*} password 
   * @param {*} uapp_id 
   */
  async getItemByPwd(channel_userid, password, uapp_id) {
    return this.model.findOne({
      where: {
        channel_userid: channel_userid,
        password: password,
        uapp_id: uapp_id
      },
      attributes: ["id",
        "uapp_id",
        "channel_userid",
        "channel_username",
        "channel_nickname",
        "open_id",
        "head_url",
        "mobile",
        "org_name",
        "org_path",
        "email",
        "is_admin",
        "is_super",
        "is_enabled"],
      raw: true
    });
  }
  /**
 * 通过用户手机号进行登录
 * @param {*} mobile 
 * @param {*} uapp_id 
 */
  async getItemByMobile(mobile, uapp_id) {
    return this.model.findOne({
      where: {
        mobile: mobile,
        uapp_id: uapp_id
      },
      attributes: ["id",
        "uapp_id",
        "channel_userid",
        "channel_username",
        "channel_nickname",
        "open_id",
        "head_url",
        "mobile",
        "org_name",
        "org_path",
        "email",
        "is_admin",
        "is_super",
        "is_enabled"],
      raw: true
    });
  }
}
module.exports = AppuserDao;
