const system = require("../../../system");
const Dao = require("../../dao.base");
class ProductDao extends Dao {
  constructor() {
    super(Dao.getModelName(ProductDao));
  }
  async getItemByChannelItemCode(channelItemCode, uapp_id) {
    return this.model.findOne({
      where: {
        uapp_id: uapp_id,
        channel_item_code: channelItemCode
      },
      attributes: [
        "id",
        "uapp_id",
        "is_enabled",
        "path_code",
        "path_name",
        "item_code",
        "item_name",
        "channel_item_code",
        "channel_item_name",
        "service_business_code",
        "service_business_name",
        "pic_url",
        "product_short_desc",
        "product_desc",
        "desc_url",
        "icon_url",
        "pay_after_jump_h5url",
        "pay_after_jump_pcurl",
        "productType_id",
        "pc_pic_url",
        "pc_desc_url"
      ],
      raw: true
    });
  }
}
module.exports = ProductDao;
