const system = require("../../../system");
const settings = require("../../../../config/settings");
const uiconfig = system.getUiConfig2(settings.appKey);
module.exports = (db, DataTypes) => {
  return db.define("oplog", {
    appid: DataTypes.STRING,
    appkey: DataTypes.STRING,
    requestId: DataTypes.STRING,
    logLevel: {
      type: DataTypes.ENUM,
      allowNull: false,
      values: Object.keys(uiconfig.config.pdict.logLevel),
      defaultValue: "info",
    },
    op: DataTypes.STRING,
    content: DataTypes.STRING(5000),
    resultInfo: DataTypes.TEXT('long'),
    clientIp: DataTypes.STRING,
    agent: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    opTitle: DataTypes.TEXT,
  }, {
      paranoid: false,//假的删除
      underscored: true,
      version: true,
      freezeTableName: true,
      timestamps: true,
      updatedAt: false,
      //freezeTableName: true,
      // define the table's name
      tableName: 'p_op_log',
      validate: {

      },
      indexes: [
        // Create a unique index on email
        //  {
        //    unique: true,
        //    fields: ['email']
        //  },
        //
        //  // Creates a gin index on data with the jsonb_path_ops operator
        //  {
        //    fields: ['data'],
        //    using: 'gin',
        //    operator: 'jsonb_path_ops'
        //  },
        //
        //  // By default index name will be [table]_[fields]
        //  // Creates a multi column partial index
        //  {
        //    name: 'public_by_author',
        //    fields: ['author', 'status'],
        //    where: {
        //      status: 'public'
        //    }
        //  },
        //
        //  // A BTREE index with a ordered field
        //  {
        //    name: 'title_index',
        //    method: 'BTREE',
        //    fields: ['author', {attribute: 'title', collate: 'en_US', order: 'DESC', length: 5}]
        //  }
      ]
    });
}
