const system = require("../../../system");
const settings = require("../../../../config/settings");
const uiconfig = system.getUiConfig2(settings.appKey);
module.exports = (db, DataTypes) => {
  return db.define("app", {
    app_hosts: DataTypes.STRING(255),
    app_code: DataTypes.STRING(64),  //渠道码 
    app_name: DataTypes.STRING(100),
    uapp_id: DataTypes.STRING(64), //平台appid
    uapp_key: DataTypes.STRING(64), //平台appkey,用于进行签名请求接口
    uapp_secret: DataTypes.STRING(64), //平台appkey密钥信息
    contact_name: DataTypes.STRING(50), //联系人
    contact_mobile: DataTypes.STRING(50), //联系电话
    contact_email: DataTypes.STRING(50), //联系人邮箱
    is_enabled: { //状态 0禁用 1启用
      type: DataTypes.BOOLEAN,
      defaultValue: true,
    },
    is_sign: { //请求是否验签
      type: DataTypes.BOOLEAN,
      defaultValue: true,
    },
    pay_type: {
      type: DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.pay_type)
    },
    delivery_type: {
      type: DataTypes.ENUM,
      values: Object.keys(uiconfig.config.pdict.delivery_type)
    },
  }, {
      paranoid: false,//假的删除
      underscored: true,
      version: true,
      freezeTableName: true,
      timestamps: true,
      updatedAt: false,
      tableName: 'p_app',
      validate: {

      },
      indexes: [

      ]
    });
}