const system = require("../../../system");
const ServiceBase = require("../../sve.base");
const settings = require("../../../../config/settings");

class ProductService extends ServiceBase {
  constructor() {
    super("dbproduct", ServiceBase.getDaoName(ProductService));
    this.productpriceDao = system.getObject("db.dbproduct.productpriceDao");
  }
  /**
   * 通过产品类别编码路径获取产品列表
   * @param {*} actionBody pathCode 为类别编码路径，一级类下产品列表 sbfu，二级类下产品列表sbfu/sbzc
   * @param {*} appInfo 应用信息
   */
  async getProductList(actionBody, appInfo) {
    var sql = "select * from v_product where uapp_id=" + appInfo.uapp_id + " and path_code like '" + actionBody.pathCode + "%'";
    if(actionBody.productName){
      sql = "select * from v_product where uapp_id=" + appInfo.uapp_id ;
      if(actionBody.productName != "All"){
        sql += " and item_name like '" + actionBody.productName + "%'"
      }
    }
    var list = await this.customQuery(sql);
    return system.getResultSuccess(list);
  }
  /**
   * 通过渠道产品编码获取产品详情
   * @param {*} actionBody channelItemCode 渠道产品编码
   * @param {*} appInfo 应用信息
   */
  async getProductDetail(actionBody, appInfo) {
    var item = await this.dao.getItemByChannelItemCode(actionBody.channelItemCode, appInfo.uapp_id);
    if (!item) {
      return system.getResult(null, "product item is data empty ！");
    }
    if (item.is_enabled != 1) {
      return system.getResult(null, "product to item is Disable ！");
    }
    var pList = await this.productpriceDao.model.findAll({
      where: { product_id: item.id },
      attributes: ["id", "pay_code", "price", "supply_price", "service_charge", "public_expense", "is_default", "is_show", "price_type", "price_type_name",
        "channel_profit_rate", "sort", "price_desc", "min_qty", "max_qty", "service_code"
      ],
      order: [ [ "price", 'ASC' ] ],
      raw: true
    });
    if (!pList || pList.length == 0) {
      return system.getResult(null, "product to price is data empty ！");
    }
    item.price_list = pList;
    return system.getResultSuccess(item);
  }
  /**
   * 获取产品接口信息
   * @param {*} actionBody productId产品id
   */
  async getProductInterface(pobj, actionBody) {
    var sql = "select * from v_op_interface where is_enabled=1 and uapp_id=" + pobj.appInfo.uapp_id + " and product_id=" + actionBody.product_id;
    var list = await this.customQuery(sql);
    return system.getResultSuccess(list);
  }
  /**
   * 获取应用接口信息
   * @param {*} actionBody
   */
  async getAppInterface(pobj, actionBody) {
    var sql = "select * from v_op_interface where is_enabled=1 and product_id is null and uapp_id=" + pobj.appInfo.uapp_id;
    var list = await this.customQuery(sql);
    return system.getResultSuccess(list);
  }

  async getaliicProduce(actionBody) {
    var producesql = "";
    if (actionBody.regType == "ali.companyreg") {
      var area = actionBody.area || "";
      producesql = "SELECT pc.pay_code payCode,pt.channel_item_code channelItemCode,pc.service_code FROM `p_product` pt JOIN p_product_price pc ON pt.id = pc.product_id WHERE pt.channel_item_name LIKE '%" + actionBody.city
        + "%' AND pc.price_desc LIKE '%" + area
        + "%' and pc.additions_desc LIKE '%" + actionBody.companyCategory + "%' ;"
    } else {
      producesql = "SELECT pc.pay_code payCode,pt.channel_item_code channelItemCode,pc.service_code FROM `p_product` pt JOIN p_product_price pc ON pt.id = pc.product_id WHERE pt.channel_item_name LIKE '%" + actionBody.park
        + "%' AND pc.price_desc LIKE '%" + actionBody.productType + "%' ;"
    }
    var produceinfo = await this.customQuery(producesql);
    if (produceinfo) {
      actionBody.payCode = produceinfo[0].payCode;
      actionBody.channelItemCode = produceinfo[0].channelItemCode;
      actionBody.service_code = produceinfo[0].service_code;
    }
    return system.getResultSuccess(actionBody);
  }

  async getaliicpProduce(actionBody,appInfo) {
    // var uapp_id = appInfo && appInfo.uapp_id?appInfo.uapp_id:"";
    var producesql = "SELECT pc.pay_code payCode,pt.channel_item_code channelItemCode,pc.price price,pc.service_code FROM `p_product` pt JOIN p_product_price pc ON pt.id = pc.product_id WHERE pt.channel_item_code LIKE '%" + actionBody.typeCode
      + "%' AND pc.price_desc='"+actionBody.province+"' ";
    // if(uapp_id){
    //   producesql = producesql+" and  uapp_id="+uapp_id;
    // }
    var produceinfo = await this.customQuery(producesql);
    if (produceinfo) {
      actionBody.payCode = produceinfo[0].payCode;
      actionBody.channelItemCode = produceinfo[0].channelItemCode;
      actionBody.price = produceinfo[0].price;
      actionBody.service_code = produceinfo[0].service_code;
    }
    return system.getResultSuccess(actionBody);
  }
  async getIcpProduce(actionBody,appInfo) {
    var uapp_id = appInfo && appInfo.uapp_id?appInfo.uapp_id:"";
    var producesql = "SELECT pc.service_code,pc.pay_code payCode,pt.channel_item_code channelItemCode,pc.price price FROM `p_product` pt JOIN p_product_price pc ON pt.id = pc.product_id WHERE pt.channel_item_code LIKE '%" + actionBody.typeCode
      + "%' AND pc.price_desc='"+actionBody.province+"' ";
    if(uapp_id){
      producesql = producesql+" and  pc.uapp_id="+uapp_id;
    }
    var produceinfo = await this.customQuery(producesql);
    if (produceinfo) {
      actionBody.payCode = produceinfo[0].payCode;
      actionBody.channelItemCode = produceinfo[0].channelItemCode;
      actionBody.price = produceinfo[0].price;
      actionBody.service_code = produceinfo[0].service_code;
    }
    return system.getResultSuccess(actionBody);
  }


  /**
   * 工商H5 产品询价
   * @param actionBody
   * @returns {Promise<{msg: *, data, status: number}>}
   */
  async getProductPrice(actionBody){
    let pathCode = actionBody.pathCode;
    let channelItemCode = actionBody.channelItemCode;
    const code1 = pathCode.split('/')[1];//一级产品码
    const code2 = pathCode.split('/')[2];//二级产品码
    let channel_item_code = code2;
    var producesql = `SELECT pc.pay_code payCode,pt.channel_item_code channelItemCode,pc.price price,pc.service_code FROM p_product pt JOIN p_product_price pc ON pt.id = pc.product_id WHERE is_show = 1 AND pt.channel_item_code = '${channelItemCode}'`;
    switch (code1) {
      case 'sbfu':
        channel_item_code = channelItemCode;
        break;
      case 'zzxk':
        if(actionBody.province ){
          producesql += ` AND pc.price_desc LIKE '%${actionBody.province}%'`;
        }else{
          return system.getResultFail(null,'actionBody.province can not be empty!')
        }
        if(actionBody.time!= ''){
          const index = actionBody.time.indexOf('个');
          const time = actionBody.time.substring(0,index);
          producesql += ` AND pc.additions_desc  = '${time}'`;
        }else{
          return system.getResultFail(null,'actionBody.time can not be empty!')
        }
        break;
      case 'bqfu':
        if(actionBody.serviceType ){
          producesql += ` AND pc.price_desc LIKE '%${actionBody.serviceType}%'`;
        }else{
          return system.getResultFail(null,'actionBody.serviceType can not be empty!')
        }
        if(actionBody.time!= ''){
          const index = actionBody.time.indexOf('个');
          const time = actionBody.time.substring(0,index)
          producesql += ` AND pc.additions_desc = '${time}'`;
        }else{
          return system.getResultFail(null,'actionBody.time can not be empty!')
        }
        break;
      case 'gsfu':
        if(code2 != 'ysgszc'){
          if(actionBody.city && actionBody.serviceType ){
            let str = actionBody.city + actionBody.serviceType;
            producesql += ` AND pc.price_desc LIKE '%${str}%'`;
          }else{
            return system.getResultFail(null,'actionBody.serviceType can not be empty!')
          }
        }else{
          let str = actionBody.city;
          producesql += ` AND pc.price_desc LIKE '%${str}%'`;
        }
        if(actionBody.companyType != ''){
          producesql += ` AND pc.additions_desc LIKE '%${actionBody.companyType}%'`;
        }else{
          return system.getResultFail(null,'actionBody.companyType and actionBody.companyType can not be empty!')
        }
        break;
      case 'csfw':
        if(actionBody.city){
          let str = actionBody.city;
          if(code2 == 'gsdz' || code2 == 'sksq'){
            str += actionBody.serviceType;
          }
          producesql += ` AND pc.price_desc LIKE '%${str}%'`;
        }else{
          return system.getResultFail(null,'actionBody.serviceType can not be empty!')
        }
        if(code2 == 'sksq'){
          producesql += ` AND pc.additions_desc = '${actionBody.companyType}'`
        }
        break;
      // 2020 0927 lin 新增 /zzfw/wangwen/ 询价方法
      case 'zzfw':
        if(actionBody.city){
          let str = actionBody.city;
          producesql += ` AND pc.price_desc LIKE '%${str}%'`;
        }else{
          return system.getResultFail(null,'actionBody.serviceType can not be empty!')
        }
        break;
      default:
        producesql +=  ` AND pt.channel_item_code = '${code2}'`;
        break;
    }
    var produceinfo = await this.customQuery(producesql);
    if (produceinfo.length != 0) {
      actionBody.payCode = produceinfo[0].payCode;
      actionBody.channelItemCode = produceinfo[0].channelItemCode;
      actionBody.price = produceinfo[0].price;
      actionBody.service_code = produceinfo[0].service_code;
      return system.getResultSuccess(actionBody);
      // 2020 1015 lin 修改 如果没查到则返回错误信息
    } else {
      return system.getResult(null, "getProductPrice fail , please check actionBody");
    }
  }


  //2020-12-21 baidu reg copy todo
  async getRegProducePrice(actionBody){
    console.log('actionBody---',actionBody)
    var itemCode = {
      item_code:actionBody.channelItemCode || actionBody.typeCode
    }
    var pathSql = "SELECT path_code,channel_item_code,service_business_code FROM p_product WHERE item_code = :item_code";
    var pathCodeData = await this.customQuery(pathSql,itemCode);
    if(actionBody.pathCode){
    var pathCode = actionBody.pathCode;
    }else{
      if(pathCodeData){
        var pathCode = pathCodeData[0].path_code; 
      }
    }
    console.log('pathCode---',pathCode)
    if(actionBody.channelItemCode){
      var channelItemCode = actionBody.channelItemCode;
    }else{
      if(pathCodeData){
        var channelItemCode = pathCodeData[0].channel_item_code; 
      }
    }
    if(pathCodeData){
      var serviceBusinessCode = pathCodeData[0].service_business_code;
    }
    const code1 = pathCode.split('/')[1];//一级产品码
    const code2 = pathCode.split('/')[2];//二级产品码
    let channel_item_code = code2;
    var producesql = `SELECT pc.service_code,pc.pay_code payCode,pt.channel_item_code channelItemCode,pc.price price FROM p_product pt JOIN p_product_price pc ON pt.id = pc.product_id WHERE is_show = 1 AND pt.channel_item_code = '${channelItemCode}'`;
    switch (code1) {
      case 'sbfu':
        channel_item_code = channelItemCode;
        break;
      case 'zzxk':
        if(actionBody.province ){
          producesql += ` AND pc.price_desc LIKE '%${actionBody.province}%'`;
        }else{
          return system.getResultFail(null,'actionBody.province can not be empty!')
        }
        if(actionBody.time!= ''){
          const index = actionBody.time.indexOf('个');
          const time = actionBody.time.substring(0,index);
          producesql += ` AND pc.additions_desc  = '${time}'`;
        }else{
          return system.getResultFail(null,'actionBody.time can not be empty!')
        }
        break;
      case 'bqfu':
        if(actionBody.serviceType ){
          producesql += ` AND pc.price_desc LIKE '%${actionBody.serviceType}%'`;
        }else{
          return system.getResultFail(null,'actionBody.serviceType can not be empty!')
        }
        if(actionBody.time!= ''){
          const index = actionBody.time.indexOf('个');
          const time = actionBody.time.substring(0,index)
          producesql += ` AND pc.additions_desc = '${time}'`;
        }else{
          return system.getResultFail(null,'actionBody.time can not be empty!')
        }
        break;
      case 'gsfu':
        if(code2 != 'ysgszc'){
          if(actionBody.city && actionBody.serviceType ){
            let str = actionBody.city + actionBody.serviceType;
            producesql += ` AND pc.price_desc LIKE '%${str}%'`;
          }else{
            return system.getResultFail(null,'actionBody.serviceType can not be empty!')
          }
        }else{
          let str = actionBody.city;
          producesql += ` AND pc.price_desc LIKE '%${str}%'`;
        }
        if(actionBody.companyType != ''){
          producesql += ` AND pc.additions_desc LIKE '%${actionBody.companyType}%'`;
        }else{
          return system.getResultFail(null,'actionBody.companyType and actionBody.companyType can not be empty!')
        }
        break;
      case 'csfw':
        if(actionBody.city){
          let str = actionBody.city;
          if(code2 == 'gsdz' || code2 == 'sksq'){
            str += actionBody.serviceType;
          }
          producesql += ` AND pc.price_desc LIKE '%${str}%'`;
        }else{
          return system.getResultFail(null,'actionBody.serviceType can not be empty!')
        }
        if(code2 == 'sksq'){
          producesql += ` AND pc.additions_desc = '${actionBody.companyType}'`
        }
        break;
      // 2020 0927 lin 新增 /zzfw/wangwen/ 询价方法
      case 'zzfw':
        if(actionBody.city){
          let str = actionBody.city;
          producesql += ` AND pc.price_desc LIKE '%${str}%'`;
        }else{
          return system.getResultFail(null,'actionBody.serviceType can not be empty!')
        }
        break;
        // 2020-12-21新增 /REG/GSREG/ 询价方法
      case 'REG':
        if(code2 == "GSREG"){
          if(actionBody.city && actionBody.taxpayerType ){
            let str = actionBody.city + actionBody.taxpayerType;
            producesql += ` AND pc.price_desc = '${str}'`;
          }
          if(actionBody.companyProperties){
            producesql += ` AND pc.additions_desc = '${actionBody.companyProperties}'`;
          }else{
            return system.getResultFail(null,'actionBody.companyProperties and actionBody.companyProperties can not be empty!')
          }
        }
        break;
      default:
        producesql +=  ` AND pt.channel_item_code = '${code2}'`;
        break;
    }
    var produceinfo = await this.customQuery(producesql);

    if (produceinfo.length != 0) {
      actionBody.payCode = produceinfo[0].payCode;
      actionBody.channelItemCode = produceinfo[0].channelItemCode;
      actionBody.price = produceinfo[0].price;
      actionBody.serviceBusinessCode = serviceBusinessCode
      actionBody.service_code = produceinfo[0].service_code
      return system.getResultSuccess(actionBody);
    } else {
      return system.getResult(null, "getRegProduce fail , please check actionBody");
    }
  }

  /**
   * 获取最低价
   * @returns {Promise<void>}
   */
  async getMinPrice(pobj){
    let data ={};
    if(!pobj.actionBody.product_id){
      return system.getResultFail(-1,'product_id is empty');
    }
    let sql = `select min(price) price from p_product_price where product_id = ${pobj.actionBody.product_id}`;
    let result = await this.customQuery(sql);
    if(result){
      data = result[0];
    }
    return system.getResultSuccess(data);
  }

  /**
   * 获取推荐产品列表
   * @param pobj
   * @returns {Promise<void>}
   */
  async getProductRecommend(actionBody,appInfo){
    const type = actionBody.type;
    let sql=``;
    let paramsWhere ={};
    if(type ==1 ){
      sql = `select DISTINCT(recommend_code) from p_company_recommend where company_name = :companyName`;
      paramsWhere['companyName'] = actionBody.companyName;
    }
    if(type ==2 ){
      sql = `select DISTINCT(recommend_code) from p_company_recommend where company_name = :companyName and product_code = :productCode`;
      paramsWhere['companyName'] = actionBody.companyName;
      paramsWhere['productCode'] = actionBody.productCode;
    }
    if(type ==3 ){
      sql = `select DISTINCT(recommend_code) from p_product_recommend where product_code = :productCode`;
      paramsWhere['productCode'] = actionBody.productCode;
    }
    let result = await this.customQuery(sql,paramsWhere);
    if(result.length==0){
      return system.getResultFail(-1,'暂无配置数据')
    }
    let codes = [];
    result.forEach(item =>{
      if(item.recommend_code){
        codes.push(item.recommend_code)
      }
    })
    paramsWhere ={};
    let productSql = `select * from v_product where channel_item_code in (:codes) and uapp_id = :uapp_id`
    paramsWhere['uapp_id'] = appInfo.uapp_id;
    let rtn={};
    if(codes.length>0){
      paramsWhere['codes'] = codes;
      rtn = await this.customQuery(productSql,paramsWhere);
    }
    return system.getResult(rtn);
  }

  /**
   * 更改产品销售价格
   * @param actionBody
   * @returns {Promise<void>}
   */
  async updateProductPrice(actionBody,appInfo){
    let arr = actionBody.data;
    let successRet = [];
    let failRet = [];
    for(let i =0;i<arr.length;i++){
      const item = arr[i];
      let obj = {};
      if(!item.payCode || !item.price){
        continue;
      }
      let sql = "SELECT a.uapp_id,a.item_name,b.id,b.product_id,b.pay_code,b.price,b.supply_price FROM `p_product` a LEFT JOIN `p_product_price` b ON  a.id = b.product_id where b.pay_code = :payCode and a.uapp_id = :uapp_id";
      let whereParams = {
        payCode:item.payCode,
        uapp_id:appInfo.uapp_id
      }
      let productPrice = await this.customQuery(sql,whereParams);
      if(!productPrice || productPrice.length == 0){
          obj ={
            payCode:item.payCode,
            message:'暂无产品'
          }
          failRet.push(obj);
          continue;
      }
      let price = productPrice[0].supply_price;
      if(item.price < price){
        obj ={
          payCode:item.payCode,
          message:'修改的价格不能低于供货价'
        }
        failRet.push(obj);
        continue;
      }
      let updateFields = {
        price : item.price
      }
      let ret = await this.productpriceDao.updateByWhere(updateFields, { where: { id: productPrice[0].id } });
      if(ret){
        successRet.push(item.payCode)
      }else{
        obj ={
          payCode:item.payCode,
          message:'修改失败'
        }
        failRet.push(obj);
      }
    }
    return system.getResultSuccess({successRet,failRet})
  }

  /**
   * 获取所有渠道的产品
   * @returns {Promise<void>}
   */
  async getAllProducts(){
    let sql = `select DISTINCT(channel_item_name),item_code from p_product`;
    let result = await this.customQuery(sql);
    let arr = [];
    result.forEach(item=>{
      if (item.channel_item_name.indexOf('市') == item.channel_item_name.length-1) {
        item.channel_item_name += '公司注册'
      }
      if (item.channel_item_name.indexOf('区') == item.channel_item_name.length-1) {
        item.channel_item_name += '公司注册'
      }
      if (item.item_code == '10202010202001'){
        item.item_code = 'zzsbzc';
      }
      if (item.item_code == '10202010202002'){
        item.item_code = 'fzsbzc';
      }
      if (item.item_code == '10202010202003'){
        item.item_code = 'dbsbzc';
      }
      if (item.item_code == '10202010204002'){
        item.item_code = 'icpsq';
      }
      if (item.item_code == '10202010204001'){
        item.item_code = 'edisq';
      }
      // if(!arr.includes(item)){
      //   arr.push(item)
      // }
      let ret = arr.filter(f =>{
        if(f.item_code == item.item_code){
          return f;
        }
      })
      if(ret.length == 0){
        arr.push(item)
      }
    })
    return system.getResultSuccess(arr);
  }

  /**
   * 根据条件过去产品
   * @param actionBody
   * @returns {Promise<void>}
   */
  async getProductByWhere(actionBody){
    let item = await this.dao.findOne(actionBody.whereParams);
    return system.getResult(item);
  }

  /**
   * 聚合path_name
   * @returns {Promise<void>}
   */
  async getAllPathName(){
    let sql = `SELECT path_name FROM p_product GROUP BY path_name`;
    let result = await this.customQuery(sql);
    return system.getResult(result);
  }


  //获取易名的icp产品信息
  async getymicpProduce(actionBody,appInfo) {
    console.log('actionBody---',actionBody)
    var itemCode = {
      item_code:actionBody.channelItemCode || actionBody.typeCode
    }
    var pathSql = "SELECT path_code,channel_item_code,service_business_code FROM p_product WHERE item_code = " + `'${itemCode.item_code}'` +" AND uapp_id = 52";
    var pathCodeData = await this.customQuery(pathSql,itemCode);
    if(actionBody.pathCode){
    var pathCode = actionBody.pathCode;
    }else{
      if(pathCodeData  && pathCodeData.length > 0){
        var pathCode = pathCodeData[0].path_code; 
      }
    }
    console.log('pathCode---',pathCode)
    if(actionBody.channelItemCode){
      var channelItemCode = actionBody.channelItemCode;
    }else{
      if(pathCodeData  && pathCodeData.length > 0){
        var channelItemCode = pathCodeData[0].channel_item_code; 
      }
    }
    if(pathCodeData && pathCodeData.length > 0){
      var serviceBusinessCode = pathCodeData[0].service_business_code;
    }
    const code1 = pathCode.split('/')[1];//一级产品码
    const code2 = pathCode.split('/')[2];//二级产品码
    let channel_item_code = code2;
    var producesql = `SELECT pc.service_code,pc.pay_code payCode,pt.channel_item_code channelItemCode,pc.price price FROM p_product pt JOIN p_product_price pc ON pt.id = pc.product_id WHERE is_show = 1  AND pt.uapp_id = 52 AND pt.channel_item_code = '${channelItemCode}'`;
    switch (code1) {
      case 'zzfw':
        if(actionBody.city){
          let str = actionBody.city;
          producesql += ` AND pc.price_desc = '${str}'`;
        }else{
          return system.getResultFail(null,'actionBody.serviceType can not be empty!')
        }
        break;
      default:
        producesql +=  ` AND pt.channel_item_code = '${code2}'`;
        break;
    }
    var produceinfo = await this.customQuery(producesql);

    if (produceinfo.length != 0) {
      actionBody.payCode = produceinfo[0].payCode;
      actionBody.channelItemCode = produceinfo[0].channelItemCode;
      actionBody.price = produceinfo[0].price;
      actionBody.serviceBusinessCode = serviceBusinessCode
      actionBody.service_code = produceinfo[0].service_code
      return system.getResultSuccess(actionBody);
    } else {
      return system.getResult(null, "getRegProduce fail , please check actionBody");
    }
  }
}
module.exports = ProductService;
