var system = require("../../../system");
var settings = require("../../../../config/settings");
const AppServiceBase = require("../../app.base");
const crypto = require("crypto");
//商标查询操作
class UtilsUserSve extends AppServiceBase {
  constructor() {
    super();
    this.redisClient = system.getObject("util.redisClient");
    this.apppaliparamDao = system.getObject("db.dbapp.apppaliparamDao");
    this.logCtl = system.getObject("service.common.oplogSve");
  }
  async getH5AliDingUserByCode(pobj) {
    var item = await this.apppaliparamDao.getItemByUAppId(Number(pobj.appInfo.uapp_id || 0));
    if (!item) {
      return system.getResult(null, "应用对应的配置数据为空!");
    }
    var accessTokenResult = await this.getDingAccessToken(pobj, item);
    if (accessTokenResult.status != 0) {
      return accessTokenResult;
    }
    var param = {
      access_token: accessTokenResult.data.access_token,
      code: pobj.actionBody.code
    };
    var userResult = await this.execGetUrl(param, "https://oapi.dingtalk.com/user/getuserinfo");
    this.logCtl.info({
      appid: pobj.appInfo ? pobj.appInfo.uapp_id : "",
      appkey: pobj.appInfo ? pobj.appInfo.uapp_key : "",
      op: "https://oapi.dingtalk.com/user/getuserinfo",
      content: "参数：" + JSON.stringify(param) + "返回结果：" + JSON.stringify(userResult),
      optitle: "获取钉钉用户信息返回",
    });
    if (userResult.status != 0) {
      return userResult;
    }
    if (userResult.data.errcode != 0) {
      return system.getResult(null, userResult.data.errmsg + "-userResult");
    }
    return system.getResultSuccess({
      channelUserId: userResult.data.userid,
      isAdmin: userResult.data.is_sys && userResult.data.is_sys == true ? 1 : 0,
      isSuper: userResult.data.sys_level && userResult.data.sys_level == 1 ? 1 : 0
    });
  }


  /**
     * 获取钉钉jsapi鉴权的参数
     * @param {*} pobj 
     * @param {*} actionBody 
     */
  async getDingJsApiAuthentication(pobj) {
    var item = await this.apppaliparamDao.getItemByUAppId(pobj.appInfo.uapp_id);
    if (!item) {
      return { status: -310, msg: "应用没有对应的支付凭证" }
    }
    var accessTokenResult = await this.getDingAccessToken(pobj, item);
    if (accessTokenResult.status != 0) {
      return accessTokenResult;
    }
    var ticketResult = await this.getDingTicket(pobj, item, accessTokenResult.data.access_token);
    if (ticketResult.status != 0) {
      return ticketResult;
    }
    var timeStamp = Date.now();
    var nonceStr = await this.getBusUid("sy");
    var nowPageUrl = pobj.actionBody && pobj.actionBody.nowPageUrl ? pobj.actionBody.nowPageUrl : "http://alitm.qifu.gongsibao.com/";
    var parameters = {
      agentId: item.agent_id,
      corpId: item.corp_id,
      timeStamp: timeStamp.toString(),
      nonceStr: nonceStr.toUpperCase()
    };
    var signature = await this.getJsApiSingnature(pobj, ticketResult.data.ticket, parameters.nonceStr, parameters.timeStamp, nowPageUrl);
    parameters.signature = signature;
    return system.getResultSuccess(parameters);
  }

  async getDingAccessToken(pobj, item) {//获取钉钉access_token----本类中调用
    var param = {
      appkey: item.appkey,
      appsecret: item.appsecret
    };
    var accessTokenResult = await this.execGetUrl(param, "https://oapi.dingtalk.com/gettoken");
    this.logCtl.info({
      appid: pobj.appInfo ? pobj.appInfo.uapp_id : "",
      appkey: pobj.appInfo ? pobj.appInfo.uapp_key : "",
      op: "https://oapi.dingtalk.com/gettoken",
      content: "参数：" + JSON.stringify(param) + "返回结果：" + JSON.stringify(accessTokenResult),
      optitle: "获取钉钉access_token信息返回",
    });
    if (accessTokenResult.status != 0) {
      return accessTokenResult;
    }
    if (accessTokenResult.data.errcode != 0) {
      return system.getResult(null, accessTokenResult.data.errmsg);
    }
    return accessTokenResult;
  }

  async getDingTicket(pobj, item, access_token) {//获取钉钉jsapi_ticket----本类中调用
    var ticketCachekey = settings.cacheprefix + "_ali-ticket:" + item.appkey;
    var cacheValue = await this.redisClient.get(ticketCachekey);
    if (cacheValue && cacheValue != "undefined" && cacheValue != "null") {
      return JSON.parse(cacheValue)
    }
    var param = {
      access_token: access_token
    };
    var ticketResult = await this.execGetUrl(param, "https://oapi.dingtalk.com/get_jsapi_ticket");
    this.logCtl.info({
      appid: pobj.appInfo ? pobj.appInfo.uapp_id : "",
      appkey: pobj.appInfo ? pobj.appInfo.uapp_key : "",
      op: "https://oapi.dingtalk.com/get_jsapi_ticket",
      content: "参数：" + JSON.stringify(param) + "返回结果：" + JSON.stringify(ticketResult),
      optitle: "获取钉钉jsapi_ticket信息返回",
    });
    if (ticketResult.status != 0) {
      return ticketResult;
    }
    if (ticketResult.data.errcode != 0) {
      return system.getResult(null, ticketResult.data.errmsg);
    }
    var expireTime = ticketResult.data.expires_in || 20;
    this.redisClient.setWithEx(ticketCachekey, JSON.stringify(ticketResult), expireTime);
    return ticketResult;
  }

  /**
 * 获取JsApi鉴权签名信息----本类中调用
 * @param {*} ticket
 * @param {*} nonce
 * @param {*} timeStamp
 * @param {*} url
 */
  async getJsApiSingnature(pobj, ticket, nonce, timeStamp, url) {//获取JsApi鉴权签名信息----本类中调用

    let plainTex = "jsapi_ticket=" + ticket + "&noncestr=" + nonce + "&timestamp=" + timeStamp + "&url=" + url;

    var sha1 = crypto.createHash('sha1');
    sha1.update(plainTex, 'utf8');
    let signature = sha1.digest('hex');

    this.logCtl.info({
      appid: pobj.appInfo ? pobj.appInfo.uapp_id : "",
      appkey: pobj.appInfo ? pobj.appInfo.uapp_key : "",
      op: "center-app/app/base/service/impl/utilsSve/utilsuserSve.js/getJsApiSingnature",
      content: "参数：" + plainTex + "，signature=" + signature,
      optitle: "记录钉钉鉴权签名信息参数5",
    });

    return signature;
  }
}
module.exports = UtilsUserSve;
