const APIBase = require('../../api.base');
const system = require('../../../system');
const settings = require('../../../../config/settings');
const crypto = require('crypto');
const fs = require('fs');
const accesskey = '3KV9nIwW8qkTGlrPmAe3HnR3fzM6r5';
const accessKeyId = 'LTAI4GC5tSKvqsH2hMqj6pvd';
const url = 'https://gsb-zc.oss-cn-beijing.aliyuncs.com';
class OSSAPI extends APIBase {
  constructor() {
    super();
  }
  async getOssConfig() {
    const policyText = {
      expiration: '2119-12-31T16:00:00.000Z',
      conditions: [
        ['content-length-range', 0, 1048576000],
        ['starts-with', '$key', 'zc'],
      ],
    };
    const b = new Buffer(JSON.stringify(policyText));
    const policyBase64 = b.toString('base64');
    const signature = crypto.createHmac('sha1', accesskey).update(policyBase64)
      .digest()
      .toString('base64'); // base64

    const data = {
      OSSAccessKeyId: accessKeyId,
      policy: policyBase64,
      Signature: signature,
      Bucket: 'gsb-zc',
      success_action_status: 201,
      url,
    };

    return system.getResult(data);
  }
  async upfile(srckey, dest) {
    const oss = System.getObject('util.ossClient');
    const result = await oss.upfile(srckey, `/tmp/${dest}`);
    return result;
  }
  async downfile(srckey) {
    const oss = System.getObject('util.ossClient');
    const downfile = await oss.downfile(srckey).then(() => `/tmp/${srckey}`);
    return downfile;
  }
}
module.exports = OSSAPI;
