const system = require('../../../system');
const http = require('http');
const querystring = require('querystring');
const settings = require('../../../../config/settings');
const CtlBase = require('../../ctl.base');
const logCtl = system.getObject('web.common.oplogCtl');
const cacheBaseComp = null;
class RoleCtl extends CtlBase {
  constructor() {
    super('auth', CtlBase.getServiceName(RoleCtl));
    this.redisClient = system.getObject('util.redisClient');
  }
  async initNewInstance(pobj, queryobj, req) {
    const rtn = {};
    rtn.roles = [];
    return system.getResultSuccess(rtn);
  }
  async create(pobj, queryobj, req) {
    const r = await super.create(pobj, queryobj, req);
    return system.getResult(r);
  }
}
module.exports = RoleCtl;
