const system = require('../../../system');
const http = require('http');
const querystring = require('querystring');
const settings = require('../../../../config/settings');
const CtlBase = require('../../ctl.base');
const moment = require('moment');
class BizOptCtl extends CtlBase {
  constructor() {
    super('bizchance', CtlBase.getServiceName(BizOptCtl));
  }
  async findAndCountAll(pobj, qobj, req) {
    // 设置查询条件
    const rs = await this.service.findAndCountAll(pobj);
    if (rs.results && rs.results.rows) {
      const result = [];
      for (const val of rs.results.rows) {
        val.company_name = val.business_info.company;
        val.customer_number = system.decryptStr(val.business_info.contactsPhone);
        val.customer_name = val.business_info.contactsName;
        val.updated_at = moment(val.updated_at).format('YYYY-MM-DD HH:mm:ss');
        val.created_at = moment(val.created_at).format('YYYY-MM-DD HH:mm:ss');
        val.schemeStatus = val['scheme.scheme_status'];
        val.serviceAddress = val.business_info.serviceName;
        val.source_name = system.SOURCENAME[val.source_name] ? system.SOURCENAME[val.source_name] : val.source_name;
        result.push(val);
      }
      rs.results.rows = result;
    }
    return system.getResult(rs);
  }

  async findBizAndSheme(pobj, qobj, req) {
    if (!pobj.id) {
      return system.getResult(null, 'id  can not be empty，100290');
    }
    const rs = await this.service.findBizAndSheme(pobj);
    return system.getResult(rs);
  }

  async closeBiz(pobj, qobj, req) {
    if (!pobj.bizId) {
      return system.getResult(null, 'bizId  can not be empty，100290');
    }
    if (!pobj.close_reason) {
      return system.getResult(null, 'close_reason  can not be empty，100290');
    }
    try {
      await this.service.closeBiz(pobj);
      return system.getResultSuccess();
    } catch (err) {
      return system.getResult(null, err.message);
    }
  }

  // 沟通记录 查询
  async communicationRecordList(pobj) {
    if (!pobj.bizId) {
      return system.getResult(null, 'bizId  can not be empty，100290');
    }
    try {
      const rs = await this.service.communicationRecordList(pobj);
      return system.getResult(rs.reverse());
    } catch (err) {
      return system.getResult(null, err.message);
    }
  }

  // 沟通记录新增
  async createCommunicationRecord(pobj) {
    if (!pobj.bizId) {
      return system.getResult(null, 'bizId  can not be empty，100290');
    }
    if (!pobj.content) {
      return system.getResult(null, 'content  can not be empty，100290');
    }
    try {
      await this.service.createCommunicationRecord(pobj);
      return system.getResultSuccess();
    } catch (err) {
      return system.getResult(null, err.message);
    }
  }
}
module.exports = BizOptCtl;
