const system = require('../../../system');
const http = require('http');
const querystring = require('querystring');
const settings = require('../../../../config/settings');
const CtlBase = require('../../ctl.base');


const cacheBaseComp = null;
class AppCtl extends CtlBase {
  constructor() {
    super('common', CtlBase.getServiceName(AppCtl));
    this.userCtl = system.getObject('service.auth.userSve');
  }
  async findAllApps(p, q, req) {
    const rtns = await this.service.findAllApps(p.userid);
    return system.getResult(rtns);
  }
  async getApp(p, q, req) {
    const app = await this.cacheManager.AppCache.cache(p.appkey, null);
    return system.getResult({ funcJson: JSON.parse(app.functionJSON) });
  }
  async translateToRouter(funarray, results, parent) {
    funarray.forEach((item) => {
      const result = {};
      result.path = item.code;
      result.name = item.code;
      result.meta = {
        hideInMenu: false,
        hideInBread: false,
        notCache: true,
        title: item.title,
        icon: 'replaceIconName',
      };
      result.component = 'replaceRightPath';
      if (parent) {
        parent.children.push(result);
      } else {
        results.push(result);
      }
      if (item.children && item.children.length > 0) {
        result.children = [];
        this.translateToRouter(item.children, results, result);
      }
    });
  }
  async buildFrontRouter(p, q, req) {
    const { appkey } = p;
    const app = await this.cacheManager.AppCache.cache(appkey, null);
    const funobj = JSON.parse(app.functionJSON);
    const results = [];
    await this.translateToRouter(funobj, results, null);
    const rtns = await this.service.upFrontRoute(results, app.id);
    await this.cacheManager.AppCache.invalidate(appkey, null);
    return system.getResult({ url: rtns.url });
  }
  async getFuncs(p, q, req) {
    const { appkey } = p;
    const app = await this.cacheManager.AppCache.cache(appkey, null);
    return system.getResult({ funcJson: JSON.parse(app.functionJSON) });
    // return system.getResult({funcJson:[]})
  }
  async saveFuncTree(p, q, req) {
    const rtn = await this.service.saveFuncTree(p);
    return system.getResult(rtn);
  }
  // async create(pobj, queryobj, req) {
  //   pobj.creator_id = pobj.userid;// 设置创建者
  //   return super.create(pobj, queryobj, req);
  // }
  async update(pobj, queryobj, req) {
    return super.update(pobj, queryobj, req);
  }

  async initNewInstance(pobj, queryobj, req) {
    const rtn = {};
    rtn.appkey = this.getUUID();
    rtn.secret = this.getUUID();
    return system.getResult(rtn);
  }
  async resetPass(pobj, queryobj, req) {
    pobj.password = await super.encryptPasswd(settings.defaultpwd);
    const rtn = this.service.resetPass(pobj);
    return system.getResult(rtn);
  }
  async createAdminUser(pobj, queryobj, req) {
    pobj.password = settings.defaultpwd;
    const rtn = this.service.createAdminUser(pobj);
    return system.getResult(rtn);
  }
  async create(pobj, queryobj, req) {
    // 设置创建者，需要同时创建app管理员、默认密码、电话
    pobj.creator_id = pobj.userid;
    //  pobj.password=super.encryptPasswd(settings.defaultpwd);
    // 构造默认的应用相关的URL
    pobj.authUrl = `${settings.protocalPrefix + pobj.domainName}/auth`;
    pobj.docUrl = `${settings.protocalPrefix + pobj.domainName}/web/common/metaCtl/getApiDoc`;
    pobj.uiconfigUrl = `${settings.protocalPrefix + pobj.domainName}/api/meta/config/fetchAppConfig`;
    pobj.opCacheUrl = `${settings.protocalPrefix + pobj.domainName}/api/meta/opCache/opCacheData`;
    pobj.notifyCacheCountUrl = `${settings.protocalPrefix + pobj.domainName}/api/meta/opCache/recvNotificationForCacheCount`;
    const app = await super.create(pobj, queryobj, req);
    return system.getResult(app);
  }
  async fetchApiCallData(pobj, queryobj, req) {
    const { curappkey } = pobj;
    // 检索出作为访问时的app呼出调用数据
    const rtn = await this.service.fetchApiCallData(curappkey);
    return system.getResultSuccess(rtn);
  }
  // 接受缓存计数通知接口
  async recvNotificationForCacheCount(p, q, req) {
    return this.service.recvNotificationForCacheCount(p);
  }
}
module.exports = AppCtl;


const p = { appkey: '08cb8300-ef1e-4e35-ba49-3de36ba497d2' };
const acl = new AppCtl();

acl.buildFrontRouter(p).then((res) => {
  console.log(res.data);
});
