const system = require('../../../system');
const http = require('http');
const querystring = require('querystring');
const settings = require('../../../../config/settings');
const CtlBase = require('../../ctl.base');

class CompanyCtl extends CtlBase {
  constructor() {
    super('common', CtlBase.getServiceName(CompanyCtl));
  }
  async update(p, q, req) {
    const u = await super.update(p, q, req);
    // 缓存失效
    await this.cacheManager.CompanyCache.invalidate(p.companykey);
    const company = await this.cacheManager.CompanyCache.cache(p.companykey);
    return system.getResult(company);
  }

  async setOrgs(p, q, req) {
    const orgs = await this.service.setOrgs(p, req.xctx.fromcompanykey);
    return system.getResult(orgs);
  }
  async getOrgs(p, q, req) {
    const companynew = await this.cacheManager.CompanyCache.cache(req.xctx.fromcompanykey);
    return system.getResult({ orgJson: JSON.parse(companynew.orgJson) });
  }
}
module.exports = CompanyCtl;
