const CacheBase = require('../cache.base');
const system = require('../../system');
const settings = require('../../../config/settings');
class CompanyCache extends CacheBase {
  constructor() {
    super();
    this.prefix = 'g_centercompanykey:';
    this.companyDao = system.getObject('db.common.companyDao');
  }
  isdebug() {
    return settings.env == 'dev';
  }
  desc() {
    return '缓存统一公司对象';
  }
  prefix() {
    return 'gc_companylocal_';
  }
  async buildCacheVal(cachekey, inputkey, val, ex, ...items) {
    const configValue = await this.companyDao.findOne({ companykey: inputkey });
    if (configValue) {
      return JSON.stringify(configValue);
    }
    return null;
  }
}
module.exports = CompanyCache;
