const system = require('../../../system');
const Sequelize = require('sequelize');
const Dao = require('../../dao.base');
const url = require('url');
class BizoptDao extends Dao {
  constructor() {
    super(Dao.getModelName(BizoptDao));
  }
  orderBy() {
    return [['updated_at', 'DESC']];
  }
  extraWhere(qobj, qw, qc) {
    // 权限添加
    // 需要添加公司查询条件
    qc.where.facilitator_id = Number(qobj.company_id || -1);
    // 组织结构
    if (qobj.opath && qobj.opath != '') {
      qc.where.salesman_opcode = { [this.db.Op.like]: `%${qobj.opath}%` };
    }

    qc.raw = true;
    qc.where.business_type = qc.where.business_type ? qc.where.business_type : {
      $in: [system.SERVICECODE.EDI, system.SERVICECODE.ICP],
    };
    switch (qobj.bizpath) {
      case '/businessManagement/wailt':
        qc.where.business_status = qc.where.business_status || {
          $in: [system.BUSSTATUS.WAITINGSCHEME, system.BUSSTATUS.WAITINGCONFIRM],
        };
        break;
      case '/businessManagement/all':
        break;
    }

    // ---- JSON 查询  start-----
    qc.where.$and = [];
    if (qc.where.linkman) {
      qc.where.$and.push(Sequelize.where(
        Sequelize.literal('business_info->"$.contactsName"'),
        qc.where.linkman,
      ));
      delete qc.where.linkman;
    }
    if (qc.where.phone_number) {
      qc.where.$and.push(Sequelize.where(
        Sequelize.literal('business_info->"$.contactsPhone"'),
        qc.where.phone_number,
      ));
      delete qc.where.phone_number;
    }
    // ---- JSON 查询  end-----

    qc.include = [
      {
        model: this.db.models.scheme,
        attributes: ['scheme_status'],
      },
    ];
    return qw;
  }
  async findBizAndSheme(id) {
    const result = await this.model.findOne({
      where: {
        id,
      },
      include: [
        {
          model: this.db.models.scheme,
          raw: false,
        },
      ],
      raw: false,
    });
    return result;
  }
}
module.exports = BizoptDao;
