const system = require('../../../system');
const Dao = require('../../dao.base');
const url = require('url');
class CacheinfoDao extends Dao {
  constructor() {
    super(Dao.getModelName(CacheinfoDao));
  }

  async createOrUpdate(pobj, t) {
    const cacheinf = await this.findOne({
      deliver_id: pobj.deliver_id,
    });
    let result = {};
    if (cacheinf) {
      // 更新
      await this.updateByWhere({
        cache_info: pobj.cache_info,
      }, {
        deliver_id: pobj.deliver_id,
      }, t);
      result = { id: cacheinf.id };
    } else {
      // 创建
      const data = await this.create(pobj, t);
      result = { id: data.id };
    }
    return result;
  }
}
module.exports = CacheinfoDao;
