const system = require('../../../system');
const settings = require('../../../../config/settings');
const appconfig = system.getSysConfig();
module.exports = (db, DataTypes) => db.define('org', {
  code: {
    type: DataTypes.STRING(64),
    allowNull: false,
  },
  name: {
    type: DataTypes.STRING(64),
    allowNull: false,
  },
  isLeaf: {
    type: DataTypes.BOOLEAN,
    defaultValue: true,
  },
  orgpath: {
    type: DataTypes.STRING,
    allowNull: false,
  },
  nodeType: { // 默认为组织
    type: DataTypes.ENUM,
    allowNull: false,
    values: Object.keys(appconfig.pdict.node_type),
    defaultValue: 'org',
  },
  isPosition: { // 是否是岗位
    type: DataTypes.BOOLEAN,
    defaultValue: false,
  },
  isMain: { // 是否是主岗
    type: DataTypes.BOOLEAN,
    defaultValue: false,
  },
}, {
  paranoid: true, // 假的删除
  underscored: true,
  version: true,
  freezeTableName: true,
  // freezeTableName: true,
  // define the table's name
  tableName: 'p_org',
  validate: {
  },
});
