const system = require('../../../system');
const ServiceBase = require('../../sve.base');
const settings = require('../../../../config/settings');
const moment = require('moment');
const pushTx = require('../../../utils/totxClient');

class BizoptService extends ServiceBase {
  constructor() {
    super('bizchance', ServiceBase.getDaoName(BizoptService));
    this.schemeDao = system.getObject('db.bizchance.schemeDao');
    this.statuslogDao = system.getObject('db.bizchance.statuslogDao');
    this.communicationrecordDao = system.getObject('db.bizchance.communicationrecordDao');
  }
  async findBizAndSheme(pobj) {
    let data = await this.dao.findBizAndSheme(pobj.id);
    if (data) {
      data = JSON.parse(JSON.stringify(data));
      const bussinessData = {
        id: data.id,
        demand_code: data.demand_code,
        business_type: data.business_type,
        company_name: data.business_info.companyName,
        customer_name: data.business_info.contactsName,
        customer_number: data.business_info.contactsPhone,
        annual_report: data.business_info.annual_report || false,
        content: data.business_info.memoInfo,
        service_address: data.business_info.serviceName,
        source_name: data.source_name,
        business_status: data.business_status,
        source_number: data.source_number,
        updated_at: moment(data.updated_at).format('YYYY-MM-DD HH:mm:ss'),
        created_at: moment(data.created_at).format('YYYY-MM-DD HH:mm:ss'),
        close_reason: data.close_reason,
      };
      let schemeData = null;
      if (data.scheme) {
        schemeData = {
          id: data.scheme.id,
          scheme_number: data.scheme.scheme_number,
          scheme_status: data.scheme.scheme_status,
          reject_reason: data.scheme.reject_reason,
          company_name: data.scheme.scheme_info.companyName,
          address: data.scheme.scheme_info.address,
          annual_report: data.scheme.scheme_info.annual_report || false,
          remark_info: data.scheme.remark_info,
          updated_at: moment(data.scheme.updated_at).format('YYYY-MM-DD HH:mm:ss'),
          created_at: moment(data.scheme.created_at).format('YYYY-MM-DD HH:mm:ss'),
        };
      }
      return {
        bussinessData,
        schemeData,
      };
    }
    return data;
  }

  async closeBiz(pobj) {
    /**
         * 1. 回传给腾讯
         * 2. 判断是否可以关闭
         * 3. 更改 商机、方案状态
         * 4. 插入更改记录
         * 5. 查询 是否有权限
         */
    const bizResult = await this.dao.findOne({
      id: pobj.bizId,
    });
    if (!bizResult) {
      throw new Error('查不到该商机');
    }
    if ([system.BUSSTATUS.CLOSED, system.BUSSTATUS.SUCCESS].includes(bizResult.business_status)) {
      throw new Error('此商机状态下不可操作');
    }

    const schemeResult = await this.schemeDao.findOne({
      bizopt_id: pobj.bizId,
    });

    await pushTx.pushCloseNeed(bizResult, pobj.close_reason);

    return this.db.transaction(async (t) => {
      await this.dao.updateByWhere({
        business_status: system.BUSSTATUS.CLOSED,
        close_reason: pobj.close_reason,
      }, {
        id: pobj.bizId,
      }, t);
      this.statuslogDao.create({
        flow_type: system.FLOWCODE.BIZ,
        flow_id: pobj.bizId,
        status_code: system.BUSSTATUS.CLOSED,
        salesman_id: pobj.userid,
        salesman_name: pobj.username,
      });
      if (schemeResult) {
        await this.schemeDao.updateByWhere({
          scheme_status: system.SCHEMESTATUS.CLOSED,
        }, {
          id: schemeResult.id,
        }, t);
        this.statuslogDao.create({
          flow_type: system.FLOWCODE.SCHEME,
          flow_id: schemeResult.id,
          status_code: system.SCHEMESTATUS.CLOSED,
          salesman_id: pobj.userid,
          salesman_name: pobj.username,
        });
      }
      return 'success';
    });
  }


  // 沟通记录 查询
  async communicationRecordList(pobj) {
    const rs = await this.communicationrecordDao.findAll({
      bizopt_id: pobj.bizId,
    });
    return rs;
  }
  // 沟通记录新增
  async createCommunicationRecord(pobj) {
    await this.communicationrecordDao.create({
      bizopt_id: pobj.bizId,
      content: pobj.content,
    });
  }
}
module.exports = BizoptService;
