const system = require('../../../system');
const ServiceBase = require('../../sve.base');
class ArticleService extends ServiceBase {
  constructor() {
    super(ServiceBase.getDaoName(ArticleService));
    this.newschannelDao = system.getObject('db.newschannelDao');
  }

  // 获取频道列表
  async findChannel(obj) {
    // const apps=await super.findAndCountAll(obj);
    const { usageType } = obj;
    if (usageType == null || usageType == '' || usageType == 'undefined') {
      return { code: -101, msg: '参数有误', data: null };
    }
    try {
      const sqlwhere = {
        where: { usageType },
        attributes: ['id', 'code', 'title', 'bgimg', 'isPubed', 'usageType', 'app_id'],
        order: [['orderNo', 'ASC']],
        raw: true,
      };
      const list = await this.newschannelDao.model.findAll(sqlwhere);
      if (list == null || list.length == 0) {
        return { code: 0, msg: '没有信息', data: null };
      }
      return { code: 1, msg: '操作成功', data: list };
    } catch (e) {
      return { code: -1, msg: '操作失败', data: null };
    }
  }

  // 获取该频道所有列表
  async findAndCountAll2(obj) {
    // const apps=await super.findAndCountAll(obj);
    const newschannel = obj.newschannel_id;
    let pageSize = obj.page_size;
    let currentPage = obj.current_page;
    if (newschannel == null || newschannel == '' || newschannel == 'undefined') {
      return { code: -101, msg: '参数有误', data: null };
    }
    if (pageSize == null || pageSize == '' || pageSize == 'undefined') {
      pageSize = '';
    }
    if (currentPage == null || currentPage == '' || currentPage == 'undefined') {
      currentPage = '';
    }
    try {
      const sqlwhere = {
        where: { newschannel_id: newschannel },
        attributes: ['id', 'code', 'title', 'listimg', 'videourl', 'desc', 'mediaType', 'usageType',
          'test', 'newschannel_id', 'app_id'],
        order: [['orderNo', 'ASC']],
        raw: true,
      };
      if (pageSize != '' && currentPage != '') {
        let tPageSize = Number(pageSize);
        let tCurrentPage = Number(currentPage);
        if (tCurrentPage < 1) {
          tCurrentPage = 1;
        }
        if (tPageSize > 50) {
          tPageSize = 50;
        }
        if (tPageSize < 1) {
          tPageSize = 1;
        }
        sqlwhere.limit = tPageSize;
        sqlwhere.offset = (tCurrentPage - 1) * tPageSize;
      }
      const list = await this.dao.model.findAll(sqlwhere);
      if (list == null || list.length == 0) {
        return { code: 0, msg: '没有信息', data: null };
      }
      return { code: 1, msg: '操作成功', data: list };
    } catch (e) {
      return { code: -1, msg: '操作失败', data: null };
    }
    //  apps.forEach(a=>{
    //    if(a.content && a.content!=""){
    //       a.content=decodeURIComponent(a.content);
    //    }
    //  });
    // console.log("xxxxxxxxxxxxxxxxxxxxyyyyyyyyyyyyyyyyxxxxxxxxxxxxxxxxx");
    // for(var arch of apps.rows){
    //   var c=arch.content.toString("utf-8") ;
    //   console.log("xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx");
    //   console.log(c);
    //   if(c && c!=""){
    //      arch.content=c;
    //   }
    // }
    //  return apps;
  }

  // 获取详细信息
  async findArticle(obj) {
    // const apps=await super.findAndCountAll(obj);
    const { id } = obj;
    if (id == null || id == '' || id == 'undefined') {
      return { code: -101, msg: '参数有误', data: null };
    }
    try {
      const sqlwhere = {
        where: { id },
        attributes: ['id', 'code', 'title', 'listimg', 'videourl', 'desc', 'content', 'mediaType', 'usageType',
          'test', 'app_id'],
        order: [['created_at', 'desc']],
        raw: true,
      };
      const list = await this.dao.model.findOne(sqlwhere);
      if (list == null || list.length == 0) {
        return { code: 0, msg: '没有信息', data: null };
      }
      return { code: 1, msg: '操作成功', data: list };
    } catch (e) {
      return { code: -1, msg: '操作失败', data: null };
    }
  }
}
module.exports = ArticleService;
