#!/usr/bin/env python
# -*- coding:utf-8 -*- 
# Author: hj
# softWare:pycharm
# fileName:qualifications_main.py
# createTime:2020/7/19 16:13

from flask import request,Flask
from flask_cors import CORS
from service.recommend_info import recommend_function
from service.select_qualification import qualificationsRoute

from service.industry_info import industryOneRoute,industryTwoRoute
from service.phone_number import phone

server = Flask(__name__)
server.config['JSON_AS_ASCII'] = False
CORS(server,supports_credentials=True) #跨域请求

qualificationsRoute(server)
industryOneRoute(server)
industryTwoRoute(server)
phone(server)


@server.route('/gsb/api/recommendation_business', methods=['POST'])
def RecommendationBusinessMain():
    if request.method == 'POST':
        request_data = request.json
        print(request_data)
        try:
            industryId = request_data['industryId']
            secondIndustry = request_data['secondIndustry']
            data = request_data['data']
            storeTypeId = request_data['storeTypeId']
            platformCode = request_data['platformCode']
            isImports = request_data['isImports']
            result = recommend_function(request_data)



            return {"status": 0, "msg": "success", "data": result}



        except Exception as error:
            return {"status": -1, "msg": "failed", "data": str(error)}

if __name__ == '__main__':
    server.run(debug=True,host='0.0.0.0',port=80)