var WEBBase = require("../../web.base");
var system = require("../../../system");
const askForSve = system.getObject("service.common.askForSve");

class askFor extends WEBBase {
    constructor() {
        super();
    }


    /**
     * @description 商标 尼斯查询 收藏 注册申请
     * @author liangwk
     * @param {*} pobj
     * @param {*} qobj
     * @param {*} req
     * @returns 
     * @memberof askFor
     */
    async tradeMark (pobj, qobj, req) {
        switch (pobj.actionType) {
            case 'niceQuery':
                const param = pobj.actionBody
                const adddic = ['首位', '中位', '末位', '随机']

                if (param.word_site) {
                    if (adddic.indexOf(param.word_site) === -1) {
                        return system.getResult(null, '请选择正确的位置')
                    }
                }

                if (isNaN(parseInt(param.name_size)) || parseInt(param.name_size) <= 0) {
                    return system.getResult(null, '字数不正确')
                } else {
                    param.name_size = parseInt(param.name_size)
                }

                if (!Array.isArray(param.ncl_one_list) || param.ncl_one_list.length === 0) {
                    return system.getResult(null, '分类不能为空')
                } else {
                    for (let i in param.ncl_one_list) {
                        if (isNaN(parseInt(param.ncl_one_list[i])) || (parseInt(param.ncl_one_list[i]) <= 0 || parseInt(param.ncl_one_list[i]) > 45)) {
                            return system.getResult(null, '分类选择不正确')
                        } else {
                            param.ncl_one_list[i] = parseInt(param.ncl_one_list[i])
                        }
                    }
                }

                let result = await askForSve.niceQuery(pobj.actionBody)
                if (result.code === 200) {
                    return system.getResult2(result.data)
                } else {
                    return system.getResult(null, result.message)
                }

            case 'collect':
                if (!pobj.actionBody.type) {
                    let result = await askForSve.getCollect(pobj)
                    if (result.status === 0) {
                        return system.getResult2(result.data)
                    } else {
                        return system.getResult(null, result.msg)
                    }
                } else {
                    let result = await askForSve.collect(pobj)
                    if (result.status === 0) {
                        return system.getResult2(result)
                    } else {
                        return system.getResult(null, result.msg)
                    }
                }
            case 'reg':
                if (!pobj.actionBody.type) {
                    let result = await askForSve.getAskFor(pobj)
                    if (result.status === 0) {
                        return system.getResult2(result.data)
                    } else {
                        return system.getResult(null, result.msg)
                    }
                } else {
                    let result = await askForSve.askFor(pobj)
                    if (result.status === 0) {
                        return system.getResult2(result.data)
                    } else {
                        return system.getResult(null, result.msg)
                    }
                }
        }
    }
}
module.exports = askFor;