var WEBBase = require("../../web.base");
var system = require("../../../system");
class TmTransactionAPI extends WEBBase {
    constructor() {
        super();
        this.pushlogSve = system.getObject("service.common.pushlogSve");
    }
    /**
      * 接口跳转-POST请求
      * actionProcess  执行的流程
      * actionType     执行的类型
      * actionBody     执行的参数
      */
    async springBoard(pobj, qobj, req) {
        if (!pobj.actionProcess) {
            return system.getResult(null, "actionProcess参数不能为空");
        }
        if (!pobj.actionType) {
            return system.getResult(null, "actionType参数不能为空");
        }
        var result = await this.opActionProcess(pobj, pobj.actionType, req);
        return result;
    }
    async opActionProcess(pobj, action_type, req) {
        var opResult = null;
        switch (action_type) {
            // sy
            case "test"://测试
                opResult = system.getResultSuccess(null, "测试成功");
                break;
            case "addPushContent"://添加推送信息
                opResult = await this.pushlogSve.addPublicServiceLog(pobj, req);
                break;
            default:
                opResult = system.getResult(null, "action_type参数错误");
                break;
        }
        return opResult;
    }

}
module.exports = TmTransactionAPI;