const system = require("../../../system");
var settings = require("../../../../config/settings");
const querystring = require('querystring');
const AppServiceBase = require("../../app.base");
class UtilsFgbusinesschancService extends AppServiceBase {
    constructor() {
        super();
        this.utilsPushSve = system.getObject("service.utilsSve.utilsPushSve");
        this.logCtl = system.getObject("service.common.oplogSve");
        this.centerOrderUrl = settings.centerOrderUrl();
        this.qifuPayAfterH5JumpUrl = settings.qifuPayAfterH5JumpUrl();
        this.qifuPayAfterPcJumpUrl = settings.qifuPayAfterPcJumpUrl();
        this.qifuH5PayNotifyUrl = settings.qifuH5PayNotifyUrl();
        this.centerAppUrl = settings.centerAppUrl();
        this.centerAppPayUrl = settings.centerAppUrl() + "payment/paymentApi/springBoard";
    };

    async create(pobj, actionBody) {
        if (!actionBody.businessData) {
            return system.getResult(null, "actionBody.businessData can not be empty，100290");
        }
        if (!actionBody.businessType) {
            return system.getResult(null, "actionBody.businessType can not be empty，100290");
        }
        if (!Array.isArray(actionBody.businessData)) {
            return system.getResult(null, "actionBody.businessData should be Array，100290");
        }
        if (actionBody.businessType === "关联推荐" && !actionBody.customerType) {
            return system.getResult(null, "关联推荐时,customerType不能为空");
        }
        var self = this;

        var reqUrl = this.centerOrderUrl + "action/fgbusinesschance/springBoard";
        for (let index = 0; index < actionBody.businessData.length; index++) {
            var item = actionBody.businessData[index];
            if (item) {
                var tmpPobj = {
                    appInfo: pobj.appInfo,
                    actionType: "create",
                    actionBody: {
                        ...item,
                        businessType: actionBody.businessType,
                        customerType: actionBody.customerType || ''
                    }
                }
                var tmpResult = await self.restPostUrl(tmpPobj, reqUrl);
                if (tmpResult.status == 0) {
                    self.utilsPushSve.business2Channel(tmpPobj, "pushRePurchaseBusiness");
                }
            }
        }
        return system.getResultSuccess();
    }


    async createOrderRefundFq(pobj, actionBody) {
        if (!actionBody || Object.keys(actionBody).length === 0) {
            return system.getResult(null, "actionBody can not be empty，100290");
        }
        let url = this.centerOrderUrl + "action/fgbusinesschance/springBoard";
        return await this.restPostUrl(pobj, url);
    }

    async createOnlineProductClassificiationFq(pobj, actionBody) {
        if (!actionBody.product_id) {
            return system.getResult(null, "actionBody.product_id can not be empty，100290");
        }
        let url = this.centerOrderUrl + "action/fgbusinesschance/springBoard";
        return await this.restPostUrl(pobj, url);
    }

    async createOrderInfoAndPayFq(pobj, actionBody) {
        if (!actionBody.orderInfo) {
            return system.getResult(null, "actionBody.orderInfo can not be empty，100290");
        }
        if (!actionBody.payInfo) {
            return system.getResult(null, "actionBody.payInfo can not be empty，100290");
        }
        let url = this.centerOrderUrl + "action/fgbusinesschance/springBoard";
        return await this.restPostUrl(pobj, url);
    }


    async getCompanyLabel(pobj, actionBody) {
        if (!actionBody.companyName) {
            return system.getResult(null, "actionBody.companyName can not be empty，100290");
        }
        // actionBody.companyName = await this.getConvertSemiangleStr(actionBody.companyName);
        // var url = settings.entProfileUrl() + "lable";
        var url = settings.entProfileUrl() + "gsb/api/company_hx";
        var reqParam = {
            company_name: actionBody.companyName
        }
        var result = await this.restPostWithHValueUrl(reqParam, url);
        let code = result.code || result.status
        if (code !== 200 && code !== 0) {
            return system.getResult(null, result.message || result.msg || "req is error");
        }
        return system.getResultSuccess(result.data);
    }

    async getRecommendProducts(pobj, actionBody) {
        if (!actionBody.businessId) {
            return system.getResult(null, "actionBody.businessId can not be empty，100290");
        }
        if (!actionBody.businessType) {
            return system.getResult(null, "actionBody.businessType can not be empty，100290");
        }
        // if (!["复购算法", "关联推荐", "智能监测"].includes(actionBody.businessType)) {
        //     return system.getResult(null, "actionBody.businessType don't compliance，100290");
        // }
        var url = settings.entProfileUrl() + "api/businessProduct";
        var reqParam = {
            bussines_id: actionBody.businessId,
            businessType: actionBody.businessType
        }
        var result = await this.restPostWithHValueUrl(reqParam, url);
        let code = result.code || result.status
        if (code !== 200 && code !== 0) {
            return system.getResult(null, result.message || result.msg || "req is error");
        }
        let data = { data: result.data };
        if (actionBody.businessType === "智能监测") {
            data = { data: result.data, survey_reason: result.survey_reason || [] }
        }
        if (actionBody.businessType === "关联推荐") {
            data = { data: result.data, relational_reason: result.relational_reason || [] }
        }
        if (actionBody.businessType === "公海挖掘") {
            data = { data: result.data, seas_reason: result.seas_reason || [] }
        }
        return system.getResultCustomSuccess(data);
    }

    async getOldOrder(pobj, actionBody) {
        if (!actionBody.companyName) {
            return system.getResult(null, "actionBody.companyName can not be empty，100290");
        }

        // actionBody.companyName = await this.getConvertSemiangleStr(actionBody.companyName);
        var url = settings.entProfileUrl() + "behavior";
        var reqParam = {
            company_name: actionBody.companyName
        }
        var result = await this.restPostWithHValueUrl(reqParam, url);
        let code = result.code || result.status
        if (code !== 200 && code !== 0) {
            return system.getResult(null, result.message || result.msg || "req is error");
        }
        let data = [];
        if (Array.isArray(result.data)) {
            for (let val of result.data) {
                data.push({
                    "source": val.source,//购买渠道
                    "productName": val.goods_name,//购买产品名称
                    "orderAmount": val.contract_amount,//订单金额
                    "createTime": val.purchase_date,//购买日期  
                    "companyName": val.company_name,//公司名称
                    "customerName": val.customer_name,//客户姓名
                    "num": val.num
                });
            }
        }
        return system.getResultSuccess(data);
    }

    async updateStatus(pobj, actionBody) {
        if (!actionBody.recommendId) {
            return system.getResult(null, "actionBody.recommendId can not be empty，100290");
        }
        if (!actionBody.statusName) {
            return system.getResult(null, "actionBody.statusName can not be empty，100290");
        }
        if (!actionBody.businessId) {
            return system.getResult(null, "actionBody.businessId can not be empty，100290");
        }
        if (!actionBody.userId) {
            return system.getResult(null, "actionBody.userId can not be empty，100290");
        }
        var url = settings.entProfileUrl() + "gsb/api/tj_rec_status";
        var reqParam = {
            recommendId: actionBody.recommendId,
            stateName: actionBody.statusName
        }
        var result = await this.restPostWithHValueUrl(reqParam, url);
        let code = result.code || result.status
        if (code !== 200 && code !== 0) {
            return system.getResult(null, result.message || result.msg || "req is error");
        }
        return system.getResultSuccess(result.data);
    }

    async getTalkContent(pobj, actionBody) {
        if (!actionBody.recommendId) {
            return system.getResult(null, "actionBody.recommendId can not be empty，100290");
        }

        var url = settings.entProfileUrl() + "api/talking";
        var reqParam = {
            recommendId: actionBody.recommendId
        }
        var result = await this.restPostWithHValueUrl(reqParam, url);
        let code = result.code || result.status
        if (code !== 200 && code !== 0) {
            return system.getResult(null, result.message || result.msg || "req is error");
        }
        return system.getResultSuccess(result.data);
    }

    async getMoreInfoUrl(pobj, actionBody) {
        if (!actionBody.companyName) {
            return system.getResult(null, "actionBody.companyName can not be empty，100290");
        }
        var url = settings.entProfileUrl() + `#/abc?companyName=${actionBody.companyName}`;
        return system.getResultSuccess({
            url: encodeURI(url)
        })
    }

    async getConsultingRecord(pobj, actionBody) {
        if (!actionBody.companyName) {
            return system.getResult(null, "actionBody.companyName can not be empty，100290");
        }

        var url = settings.entProfileUrl() + "gsb/api/consultingRecord";
        var reqParam = {
            company_name: actionBody.companyName
        }
        var result = await this.restPostWithHValueUrl(reqParam, url);
        let code = result.code || result.status
        if (code !== 200 && code !== 0) {
            return system.getResult(null, result.message || result.msg || "req is error");
        }
        return system.getResultSuccess(result.data);
    }

    async addStatusRemarks(pobj, actionBody) {
        if (!actionBody.recommendId) {
            return system.getResult(null, "actionBody.recommendId can not be empty，100290");
        }
        if (!actionBody.remarks) {
            return system.getResult(null, "actionBody.remarks can not be empty，100290");
        }
        var url = settings.entProfileUrl() + "gsb/api/statusRemarks";
        var reqParam = {
            recommendId: actionBody.recommendId,
            remarks: actionBody.remarks
        }
        var result = await this.restPostWithHValueUrl(reqParam, url);
        let code = result.code || result.status
        if (code !== 200 && code !== 0) {
            return system.getResult(null, result.message || result.msg || "req is error");
        }
        return system.getResultSuccess(result.data);
    }

}
module.exports = UtilsFgbusinesschancService;
