var WEBBase = require("../../web.base");
var system = require("../../../system");
var settings = require("../../../../config/settings");

class tmReview extends WEBBase {
    constructor() {
        super();
        this.utilsDeliverSve = system.getObject("service.utilsSve.utilsDeliverSve");
    }


    async springBoard(pobj, qobj, req) {
        if (!pobj.actionProcess) {
            return system.getResult(null, "actionProcess参数不能为空");
        }
        if (!pobj.actionType) {
            return system.getResult(null, "actionType参数不能为空");
        }
        var result = await this.opActionProcess(pobj, pobj.actionType, req);
        return result;
    }

    async opActionProcess(pobj, action_type, req) {
        pobj.requestId = req.requestId;
        var opResult = null;
        switch (action_type) {
            case "addReviewList"://提交复审材料
                opResult = await this.utilsDeliverSve.addReviewList(pobj,pobj.actionBody);
                break;
            case "getReOrderList"://获取订单列表信息
                opResult = await this.utilsDeliverSve.getReOrderList(pobj, pobj.actionBody);
                break;
            case "getOfficalList"://获取官文列表
                opResult = await this.utilsDeliverSve.getOfficialList(pobj,pobj.actionBody);
                break;
            case "composeDocAndDownload"://事实与理由模板下载
                opResult = await this.utilsDeliverSve.composeDocAndDownload(pobj,pobj.actionBody);
                break;
            case "getEntrustDoc"://
                opResult = await this.utilsDeliverSve.getEntrustDoc(pobj,pobj.actionBody);
                break;
            case "getPDFInfo"://解析驳回通知书获取参数
                opResult = await this.utilsDeliverSve.getPDFInfo(pobj,pobj.actionBody);
                break;
            case "receiveDeliveryData"://接收交付中心交付数据
                opResult = await this.utilsDeliverSve.receiveDeliveryInfo(pobj,pobj.actionBody);
                break;
            case "addOfficial"://接收官文信息
                opResult = await this.utilsDeliverSve.addOfficial(pobj,pobj.actionBody);
                break;
            default:
                opResult = system.getResult(null, "action_type参数错误");
                break;
        }
        return opResult;
    }

}
module.exports = tmReview;