const system = require("../system");
const moment = require('moment')
const settings = require("../../config/settings");
const md5 = require("MD5");
const uuidv4 = require('uuid/v4');
const cryptoJS = require('crypto-js');

class AppServiceBase {
    constructor() {
        this.dingClient = system.getObject("util.dingClient");
        this.restClient = system.getObject("util.restClient");
        this.execClientNew = system.getObject("util.execClientNew");
        this.execClient = system.getObject('util.execClient');
        this.cacheManager = system.getObject("db.common.cacheManager");
        this.pushlogSve = system.getObject("service.common.pushlogSve");
        this.pushlogFailType = {OLDRPC: 1, NEWRPC: 2, FAILLOG: 3, FQ: 4};//1老的rpc调用，2新的rpc调用-需配置，3错误日志，4推送峰擎,5直接调用-无需配置
        this.logCtl = system.getObject("service.common.oplogSve");
    }

    /**
     * 验证签名
     * @param {*} params 要验证的参数
     * @param {*} app_key 应用的校验key
     */
    async verifySign(params, app_key) {
        if (!params) {
            return system.getResult(null, "请求参数为空");
        }
        if (!params.sign) {
            return system.getResult(null, "请求参数sign为空");
        }
        var signArr = [];
        var keys = Object.keys(params).sort();
        if (keys.length == 0) {
            return system.getResult(null, "请求参数信息为空");
        }
        for (let k = 0; k < keys.length; k++) {
            const tKey = keys[k];
            if (tKey != "sign" && params[tKey] && !(typeof (params[tKey]) === "object")) {
                signArr.push(tKey + "=" + params[tKey]);
            }
        }
        if (signArr.length == 0) {
            return system.getResult(null, "请求参数组装签名参数信息为空");
        }
        var resultSignStr = signArr.join("&") + "&key=" + app_key;
        var resultTmpSign = md5(resultSignStr).toUpperCase();
        if (params.sign != resultTmpSign) {
            return system.getResult(null, "返回值签名验证失败");
        }
        return system.getResultSuccess();
    }

    async restPostUrl(pobj, url) {
        try {
            var rtn = await this.restClient.execPost(pobj, url);
            if (!rtn || !rtn.stdout) {
                return system.getResult(null, "restPost data is empty");
            }
            var result = JSON.parse(rtn.stdout);
            return result;
        } catch (e) {
            const stackStr = e.stack ? e.stack : JSON.stringify(e);
            this.execClientNew.execLogs(`推送操作异常-api-center-channel-url:${url}`, pobj, "center-channel-restPostUrl", null, stackStr);
            return system.getResult(null, stackStr);
        }
    }

    async restPostWithHValueUrl(pobj, url, hValue) {//curl请求带请求头信息
        try {
            if (!hValue) {
                hValue = "YLc6GsgLtuRGaVA5Om848x18NxLtHlyA";
            }
            var rtn = await this.restClient.execPostWithHValue(pobj, url, hValue);
            if (!rtn || !rtn.stdout) {
                return system.getResult(null, "execPostWithHValue data is empty");
            }
            var result = JSON.parse(rtn.stdout);
            return result;
        } catch (e) {
            const stackStr = e.stack ? e.stack : JSON.stringify(e);
            this.execClientNew.execLogs(`操作异常-api-center-channel-url:${url}`, pobj, "center-channel-restPostWithHValueUrl", null, stackStr);
            return system.getResult(null, stackStr);
        }
    }

    async restPostWithHAuthorizationUrl(pobj, userToken, url) {//curl请求带请求头信息
        try {
            var rtn = await this.restClient.restPostWithHAuthorizationUrl(userToken, url);
            if (!rtn || !rtn.stdout) {
                return system.getResult(null, "restPostWithHAuthorizationUrl data is empty");
            }
            var result = JSON.parse(rtn.stdout);
            return result;
        } catch (e) {
            const stackStr = e.stack ? e.stack : JSON.stringify(e);
            this.execClientNew.execLogs(`操作异常-api-center-channel-url:${url}`, pobj, "center-channel-restPostWithHAuthorizationUrl", null, stackStr);
            return system.getResult(null, stackStr);
        }
    }

    async execPostUrl(pobj, url) {
        try {
            var rtn = await this.execClient.execPost(pobj, url);
            if (!rtn || !rtn.stdout) {
                return system.getResult(null, "execPost data is empty");
            }
            var result = JSON.parse(rtn.stdout);
            return result;
        } catch (e) {
            const stackStr = e.stack ? e.stack : JSON.stringify(e);
            this.execClientNew.execLogs(`操作异常-api-center-channel-url:${url}`, pobj, "center-channel-restPostWithHAuthorizationUrl", null, stackStr);
            return system.getResult(null, stackStr);
        }
    }

    async opAliyunRpcVerifyParam(pobj) {//参数信息验证
        var verify = system.getResultSuccess();
        if (!pobj.interface_params) {
            verify = system.getResult(null, "interface_params can not be empty，100440");
        }
        var interface_params_info = JSON.parse(pobj.interface_params);
        if (!interface_params_info || !interface_params_info.action) {
            verify = system.getResult(null, "interface_params.action can not be empty，100443");
        }
        verify.data = interface_params_info;
        return verify;
    }

    /**
     * 阿里RPC调用
     * @param {*} pobj {action: rpcParam.action,reqbody: pobj.actionBody,rpcParam: rpcParam}
     * @param {*} params {为阿里的接口参数}
     */
    async opAliyunRpcReq(pobj, params) {
        try {
            // var action = obj.action;
            // var reqbody = obj.reqbody;
            // var rpcParam = obj.rpcParam;
            var aliyunClient = system.getObject("util.aliyunClient");
            var rtn = await aliyunClient.reqCustomByGet(params);
            return rtn;
        } catch (e) {
            params.appInfo = pobj.appInfo;
            const stackStr = e.stack ? e.stack : JSON.stringify(e);
            this.execClientNew.execLogs(`推送操作异常-api-center-channel`, params, "center-channel-opAliyunRpcReq", null, stackStr);
            return system.getResult(null, stackStr);
        }
    }

    /**
     * 处理成功后的信息
     * @param {*} pobj
     * @param {*} result
     * @param {*} opTitleDesc
     * @param {*} failType this.pushlogFailType
     */
    async disposePushResult(pobj, result, opTitleDesc, failType) {//处理结果信息--内部使用
        let opType = pobj.opType || "";
        let content = JSON.stringify(pobj);
        if (result.status != 0) {
            return this.disposePushResultFail(pobj, result, opTitleDesc, failType);
        }
        this.pushlogSve.createDb({
            appid: pobj.appInfo ? pobj.appInfo.uapp_id || "" : "",
            appkey: pobj.appInfo ? pobj.appInfo.uapp_key || "" : "",
            requestId: pobj.requestId || "",
            op: "推送业务类型：" + opType,
            content: content,//推送的参数信息
            resultInfo: JSON.stringify(result),
            returnType: '1',
            opTitle: opType + "数据推送成功->" + opTitleDesc
        });
        // 更改需求推送状态
        if (opType.indexOf('Need') >= 0 && opType.indexOf('Business') >= 0) {
            pobj.actionType = 'updateNeedPushStatus';
            let url = settings.centerOrderUrl() + 'action/opNeed/springBoard';
            this.execPostByTimeOut(null, pobj, url, null, null, 60);
        }
        if (["pushOrder", "pushOrderBusiness", "pushOrderICPBusiness", "pushOrderICPBusinessNew"].includes(opType) && pobj.actionBody && pobj.actionBody.orderNo) {
            pobj.actionBody.pushNumber = pobj.pushNumber || 1;
            pobj.actionBody.pushStatus = 3;//推送状态0待推送2推送失败3已成功推送
            this.disposeOrderPush(pobj);
        }
        return result;
    }

    /**
     * 处理失败的结果信息--内部使用
     * @param {*} pobj
     * @param {*} result
     * @param {*} opTitleDesc
     * @param {*} failType this.pushlogFailType
     */
    async disposePushResultFail(pobj, result, opTitleDesc, failType) {//处理失败的结果信息--内部使用
        var opType = pobj.opType || "";
        let pushNumber = pobj.pushNumber || 1;
        if (pushNumber >= 9) {
            pobj.actionBody.pushNumber = pushNumber;
            pobj.actionBody.pushStatus = 2;//推送状态0待推送2推送失败3已成功推送
            this.disposeOrderPush(pobj);
            if (result.errorMsg && result.errorMsg == "请与服务产品确认该产品是否上架") {
                this.disposeOrderPushFailSendDing(pobj);
            }
        }
        let resultInfo = JSON.stringify(result);
        this.pushlogSve.createFailLogDb({
            appid: pobj.appInfo ? pobj.appInfo.uapp_id || "" : "",
            appkey: pobj.appInfo ? pobj.appInfo.uapp_key || "" : "",
            requestId: pobj.requestId || "",
            content: JSON.stringify(pobj),//推送的参数信息
            resultInfo: resultInfo,
            clientIp: pobj.clientIp || "",
            failType: failType || 3,
            opTitle: opType + "推送操作失败->" + opTitleDesc,
            pushNumber: pushNumber
        });
        result.data = null;
        return result;
    }

    async disposeOrderPushFailSendDing(pobj) {
        let params = {
            orderNo: pobj.actionBody.orderNo,
            city: pobj.actionBody.city,
            area: pobj.actionBody.area,
            companyCategory: pobj.actionBody.companyCategory,
            appName: pobj.actionBody.appName,
            sku: pobj.actionBody.sku,
            error: "订单产品查询出来产品与传递得产品数量不一致，请重新选择!"
        }
        this.dingClient.businessPushFqByChannel(params);
    }

    async disposeOrderPush(pobj) {
        pobj.actionType = 'updateOrderPushStatus';
        let url = settings.centerOrderUrl() + 'action/order/springBoard';
        this.execPostByTimeOut(null, pobj, url, null, null, 60);
    }

    async getAliossjavaFileUrl(pobj, params) {//上传ali oss 文件调用
        let opType = pobj.opType || "";
        try {
            let aliOssFileInfo = await this.execPostUrl(params, settings.aliossjavaUrl());
            if (aliOssFileInfo == true) {
                let fileUrl = params.filedir + "/" + params.objectName;
                return system.getResultSuccess(fileUrl);
            }
            this.pushlogSve.createFailLogDb({
                appid: pobj.appInfo ? pobj.appInfo.uapp_id || "" : "",
                appkey: pobj.appInfo ? pobj.appInfo.uapp_key || "" : "",
                requestId: pobj.requestId || "",
                content: JSON.stringify(params),//推送的参数信息
                resultInfo: JSON.stringify(aliOssFileInfo),
                clientIp: pobj.clientIp || "",
                failType: 3,
                opTitle: opType + "aliossjava-upload阿里上传文件操作失败->getAliossjavaFileUrl",
                pushNumber: 1
            });
            return system.getResult(null, "java ali oss upload fail");
        } catch (e) {
            params.appInfo = pobj.appInfo;
            const stackStr = e.stack ? e.stack : JSON.stringify(e);
            this.execClientNew.execLogs(`aliossjava-upload阿里上传文件操作异常-api-center-channel`, params, "center-channel-getAliossjavaFileUrl", null, stackStr);
            return system.getResult(-200, "java ali oss upload error");
        }
    }

    async opDownFileInfo(docUrl, result) {  //从oss下载到本地并上传到自己oss，之后删除本地文件
        /*docUrl下载链接，全路径，如：https://XXXXXX.pdf?XXXXX */
        try {
            var tmpFileName = docUrl.substring(0, docUrl.lastIndexOf("?"));
            var fileName = tmpFileName.substr(tmpFileName.lastIndexOf("/") + 1, tmpFileName.lenght);
            var fileType = tmpFileName.substr(tmpFileName.lastIndexOf(".") + 1, tmpFileName.lenght);
            //解码后的文件全名:xxx.pdf
            var fileAllName = decodeURIComponent(fileName);//为xxx.pdf
            var saveFilePath = '/tmp/' + fileAllName;
            // 下载文件到指定的路径
            var tmpp = await this.restClient.execDownload("'" + docUrl + "'", saveFilePath);
            //上传 saveFilePath的文件 到ossClient
            var uuid = uuidv4();
            var u = uuid.replace(/\-/g, "");
            var upFileName = "alifile_" + u + "." + fileType;
            var rtn = await this.ossClient.upfile(upFileName, saveFilePath);
            result.data = rtn;
            //删除本地文件
            fs.unlink(saveFilePath, function (err) {
            });
        } catch (e) {
            result.code = -200;
            result.message = "通过flowId获取到的文件url下载操作异常异常error";
            console.log(e.stack);
            //日志记录
            logCtl.error({
                optitle: "e签宝通过flowId获取到的文件url下载操作异常异常error",
                op: "base/service/impl/utilesignbaoSve/opDownFileInfo",
                content: "请求参数：docUrl=" + docUrl + "，异常信息error：" + e.stack,
                clientIp: ""
            });
        }
        return result;
    }

    async getOpInterfaceByProductId(appInfo, product_id) {//获取产品调用接口
        var getProductInterfaceUrl = settings.centerAppUrl() + "action/opProduct/springBoard";
        var getProductInterfaceObj = {
            "actionType": "getProductInterface",
            "appInfo": appInfo,
            "actionBody": {"product_id": product_id}
        };
        var productItemInterfaceResult = await this.restPostUrl(getProductInterfaceObj, getProductInterfaceUrl);
        return productItemInterfaceResult;
    }

    async getConvertSemiangleStr(str) {//去除空格及全角转半角
        var result = "";
        str = str.replace(/\s+/g, "");
        var len = str.length;
        for (var i = 0; i < len; i++) {
            var cCode = str.charCodeAt(i);
            //全角与半角相差（除空格外）：65248（十进制）
            cCode = (cCode >= 0xFF01 && cCode <= 0xFF5E) ? (cCode - 65248) : cCode;
            //处理空格
            cCode = (cCode == 0x03000) ? 0x0020 : cCode;
            result += String.fromCharCode(cCode);
        }
        return result;
    }

    /*
    返回20位业务订单号
    prefix：业务前缀
    */
    async getBusUid(prefix) {
        prefix = (prefix || "");
        if (prefix) {
            prefix = prefix.toUpperCase();
        }
        var prefixlength = prefix.length;
        var subLen = 8 - prefixlength;
        var uidStr = "";
        if (subLen > 0) {
            uidStr = await this.getUidInfo(subLen, 60);
        }
        var timStr = moment().format("YYYYMMDDHHmm");
        return prefix + timStr + uidStr;
    }

    /*
    len：返回长度
    radix：参与计算的长度，最大为62
    */
    async getUidInfo(len, radix) {
        var chars = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ'.split('');//长度62，到yz长度为长36
        var uuid = [], i;
        radix = radix || chars.length;
        if (len) {
            for (i = 0; i < len; i++) uuid[i] = chars[0 | Math.random() * radix];
        } else {
            var r;
            uuid[8] = uuid[13] = uuid[18] = uuid[23] = '-';
            uuid[14] = '4';
            for (i = 0; i < 36; i++) {
                if (!uuid[i]) {
                    r = 0 | Math.random() * 16;
                    uuid[i] = chars[(i == 19) ? (r & 0x3) | 0x8 : r];
                }
            }
        }
        return uuid.join('');
    }

    getUUID() {
        var uuid = uuidv4();
        var u = uuid.replace(/\-/g, "");
        return u;
    }

    /**
     * 加密信息
     * @param {*} encrypt_key
     * @param {*} encrypt_secret
     * @param {*} opStr
     */
    async encryptStr(encrypt_key, encrypt_secret, opStr) {
        if (!opStr) {
            return system.getResult(null, "opStr is empty");
        }
        let keyHex = cryptoJS.enc.Utf8.parse(encrypt_key);
        let ivHex = cryptoJS.enc.Utf8.parse(encrypt_secret.substring(0, 8));
        var cipherStr = cryptoJS.TripleDES.encrypt(opStr, keyHex, {iv: ivHex}).toString();
        return cipherStr;
    }

    /**
     * 解密信息
     * @param {*} encrypt_key
     * @param {*} encrypt_secret
     * @param {*} opStr
     */
    async decryptStr(encrypt_key, encrypt_secret, opStr) {
        if (!opStr) {
            return system.getResult(null, "opStr is empty");
        }
        try {
            let keyHex = cryptoJS.enc.Utf8.parse(encrypt_key);
            let ivHex = cryptoJS.enc.Utf8.parse(encrypt_secret.substring(0, 8));
            var bytes = cryptoJS.TripleDES.decrypt(opStr, keyHex, {
                iv: ivHex
            });
            var plaintext = bytes.toString(cryptoJS.enc.Utf8);
            if (!plaintext) {
                return system.getResult(null, "解密失败" + opStr);
            }
            return system.getResultSuccess(plaintext);
        } catch (error) {
            return system.getResultFail(-200, "解密异常：" + opStr);
        }
    }

    /**
     * 带超时时间的post请求
     * @param {*} req 请求信息
     * @param {*} params 请求数据-json格式
     * @param {*} url 请求地址
     * @param {*} ContentType 请求头类型，默认application/json
     * @param {*} headData 请求头内容-json格式，如：请求头中传递token,格式：{token:"9098902q849q0434q09439"}
     * @param {*} timeOut 超时时间
     */
    async execPostByTimeOut(req, params, url, ContentType, headData, timeOut = 60) {
        const result = await this.execClientNew.execPostTimeOutByBusiness('sve.base', params, url, ContentType, headData, timeOut, req);
        return result;
    }
    /**
     * 带headData和超时时间的post请求
     * @param {*} params 请求数据-json格式
     * @param {*} url 请求地址
     * @param {*} ContentType 请求头类型，默认application/json
     * @param {*} headData 请求头内容-json格式，如：请求头中传递token,格式：{token:"9098902q849q0434q09439"}
     * @param {*} timeOut 超时时间
     */
    async execPostByHeadDataTimeOut(params, url, ContentType, headData, timeOut = 5000) {
        const result = await this.execClientNew.execPost(params, url, ContentType, headData, timeOut);
        return result;
    }

    /**
     * 验证签名
     * @param {*} params 要验证的参数
     * @param {*} app_secret 应用的校验key
     */
    async verifySign(params, app_secret) {
        if (!params) {
            return system.getResult(null, "请求参数为空");
        }
        if (!params.sign) {
            return system.getResult(null, "请求参数sign为空");
        }
        var signArr = [];
        var keys = Object.keys(params).sort();
        if (keys.length == 0) {
            return system.getResult(null, "请求参数信息为空");
        }
        for (let k = 0; k < keys.length; k++) {
            const tKey = keys[k];
            if (tKey != "sign" && params[tKey]) {
                let tmpKeyValue = params[tKey];
                if (tmpKeyValue instanceof Array || tmpKeyValue instanceof Object) {
                    tmpKeyValue = JSON.stringify(tmpKeyValue);
                }
                signArr.push(tKey + "=" + tmpKeyValue);
            }
        }
        if (signArr.length == 0) {
            return system.getResult(null, "请求参数组装签名参数信息为空");
        }
        var resultSignStr = signArr.join("&") + "&key=" + app_secret;
        var resultTmpSign = md5(resultSignStr).toUpperCase();
        if (params.sign != resultTmpSign) {
            return system.getResult(null, "返回值签名验证失败");
        }
        return system.getResultSuccess();
    }

    async getFQbossSign(pobj) {
        var signArr = [];
        var keys = Object.keys(pobj).sort();
        for (let k = 0; k < keys.length; k++) {
            const tKey = keys[k];
            if (tKey != "sign" && pobj[tKey]) {
                signArr.push(tKey + "=" + pobj[tKey]);
            }
        }
        var resultSignStr = signArr.join("&") + "&key=" + "9c83f5f5c41347fc9bb47951fef3199b";
        return md5(resultSignStr).toUpperCase();
    }
}

module.exports = AppServiceBase;
