<a name="menu" href="/doc">返回主目录</a>
1. [根据申请人查询聚合接口](#CommomSearchbyApplicant)
1. [根据申请人获取专利量接口](#paCountByApplicantName)
1. [根据申请人获取专利详情列表接口](#paShortListByApplicantName)
1. [根据公开或授权号获取专利详情列表接口](#paDetailsBypubNo)
1. [根据申请号获取专利详情列表接口](#paDetailsByfilingNo)
1. [根据公司名称得到软著量](#softwareCountByAuthor)
1. [根据公司名称得到软著详情](#softwareListByAuthor)
1. [根据登记号获取软著详情接口](#softwareDetailsByregNum)
1. [根据公司名称得到著作权量](#worksCountByAuthor)
1. [根据公司名称得到著作权详情接口](#worksListByAuthor)
1. [根据登记号获取著作权详情](#worksDetailsByregNum)
1. [根据标题查询聚合-------](#CommomSearchbyTitle)
1. [根据申请号查询聚合](#CommomSearchbyFilingno)
1. [根据公开号查询聚合](#CommomSearchbyPubno)
1. [根据发明人查询聚合](#CommomSearchbyInventor)
1. [根据申请号查询并根据法律状态日期排序](#AffairsearchbyFilingno)
1. [查询所有专利，按公开日倒序排列](#paDataOrderByPubno)


## **<a name="CommomSearchbyApplicant"> 根据申请人查询聚合接口</a>**
[返回到目录](#menu)
##### URL
[/action/patentQuery/CommomSearchbyApplicant]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`
#### 渠道执行的类型 actionType：CommomSearchbyApplicant
``` javascript
{ 
"applicant": "中国专利信息中心",//申请人名称
"pubtype": "发明",//专利类型：发明、实用新型、外观设计
"pubstatus": "",//专利法律状态
"filingyear": "",//申请年份
"pubyear": "",//公开年份
"pagesize": 20,
"page": 1 
}

```

#### 返回结果
```javascript
{ status: 0,
  msg: '操作成功',
  data:
   { total: 5,
     max_score: 49.434937,
     hits: [ 
    {
    "_index": "bigdata_patent_bib",
    "_type": "_doc",
    "_id": "201410451887",
    "_score": 49.5767,
    "_source": {
        "pub_type": "发明",
        "gr_no": "CN104298662B",
        "filing_name": "一种基于有机物命名实体的机器翻译方法及翻译系统",
        "pub_time": "2015-01-21",
        "filing_time": "2014-09-05",
        "gr_time": "2017-10-10",
        "filing_no": "201410451887",
        "inventor_name": [
            "任智军",
            "张威",
            "李进",
            "杨婧",
            "张延花"
        ],
        "pub_status": "有效",
        "applicant_name": [
            "中国专利信息中心"
        ],
        "pub_no": "CN104298662A"
        }
    }
      
    ] },
  buckets:
   { group_by_pub_status:
      { doc_count_error_upper_bound: 0,
        sum_other_doc_count: 0,
        buckets: [
            {
                "key": "有效",
                "doc_count": 4
            },
            {
                "key": "在审",
                "doc_count": 1
            }
        ] 
    },
     group_by_filing_year:
      { doc_count_error_upper_bound: 0,
        sum_other_doc_count: 0,
        buckets: [
            {
                "key": "2017",
                "doc_count": 1
            },
            {
                "key": "2014",
                "doc_count": 2
            },
            {
                "key": "2013",
                "doc_count": 1
            },
            {
                "key": "2012",
                "doc_count": 1
            }
        ] 
    },
     group_by_pub_year:
      { doc_count_error_upper_bound: 0,
        sum_other_doc_count: 0,
        buckets: [
            {
                "key": "2018",
                "doc_count": 1
            },
            {
                "key": "2015",
                "doc_count": 1
            },
            {
                "key": "2014",
                "doc_count": 2
            },
            {
                "key": "2012",
                "doc_count": 1
            }
        ] 
    },
     group_by_pub_type:
      { doc_count_error_upper_bound: 0,
        sum_other_doc_count: 0,
        buckets: [
            {
                "key": "发明",
                "doc_count": 5
            }
        ]
    } 
   } 
}

```

## **<a name="paCountByApplicantName"> 根据申请人获取专利量接口</a>**
[返回到目录](#menu)
##### URL
[/action/patentQuery/paCountByApplicantName]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`
#### 渠道执行的类型 actionType：paCountByApplicantName

``` javascript
{
  "applicant_name": "中国专利信息中心"//申请人名称
}

```

#### 返回结果
```javascript
{ status: 0, msg: '操作成功', data: 5370, bizmsg: 'empty' }
```


## **<a name="paShortListByApplicantName"> 根据申请人获取专利详情列表</a>**
[返回到目录](#menu)
##### URL
[/action/patentQuery/paShortListByApplicantName]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`
#### 渠道执行的类型 actionType：paShortListByApplicantName

``` javascript
{
    "applicant_name": "中国专利信息中心"//申请人名称
    "page_size": 20,
    "current_page": 1
}

```

#### 返回结果
```javascript
{ 
    status: 0,
    msg: '操作成功',
    data:
    { 
        total: 5,
        data: 
        [ 
            { 
                agency_name: '北京瑞恒信达知识产权代理事务所（普通合伙）',//代理机构名称
                abstr_text:'本申请提供一种研发方向识别的方法,包括:步骤1:收集专利文献,将专利文献分为新申请文献、新失效文献和其他文献三部分,将新申请文献和新失效文献整合作为分析数据库;步骤2:生成技术主题,建立主题矩阵;步骤3:计算主题矩阵的新申请相关度和新失效相关度;步骤4:识别研发方向。利用本发明的方法,可以建立规则识别四类研发状态,分析技术研发趋势,为单位的技术研发动态、调整研发策略提供参考借鉴。',//摘要
                filing_name: '一种识别研发方向的方法',//发明名称
                filing_time: '2015-01-05',//申请日
                filing_no: '201711426233',//申请号
                gr_time: null,//授权公告日
                pub_time: '2016-01-05',//公开日
                main_ipc: 'G06F17/27',//主IPC
                pub_type: '发明',//专利类型
                gr_no: null,//授权公告号
                pub_status_now: '实审',//当前状态
                applicant_name: [ '中国专利信息中心' ],//申请人
                inventor_name: [ '任智军', '谷威', '张威', '陈强', '范婷婷', '和兰', '谢慧', '张凯' ],//发明人
                pub_no: 'CN108255807A'//公开号
            }
        ] 
    },
    bizmsg: 'empty' 
}
```


## **<a name="paDetailsBypubNo"> 根据公开或授权号获取专利详情列表</a>**
[返回到目录](#menu)
##### URL
[/action/patentQuery/paDetailsBypubNo]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`
#### 渠道执行的类型 actionType：paDetailsBypubNo

``` javascript
{
    "pub_no": "北京联大共享科技",
    "gr_no": ""
}

```

#### 返回结果
```javascript
{ 
    status: 0,
    msg: '操作成功',
    data:
    { 
        total: 5,
        data: 
        [ 
            { 
                agency_name: '北京瑞恒信达知识产权代理事务所（普通合伙）',//代理机构名称
                abstr_text:'本申请提供一种研发方向识别的方法,包括:步骤1:收集专利文献,将专利文献分为新申请文献、新失效文献和其他文献三部分,将新申请文献和新失效文献整合作为分析数据库;步骤2:生成技术主题,建立主题矩阵;步骤3:计算主题矩阵的新申请相关度和新失效相关度;步骤4:识别研发方向。利用本发明的方法,可以建立规则识别四类研发状态,分析技术研发趋势,为单位的技术研发动态、调整研发策略提供参考借鉴。',//摘要
                filing_name: '一种识别研发方向的方法',//发明名称
                filing_time: '2015-01-05',//申请日
                filing_no: '201711426233',//申请号
                gr_time: null,//授权公告日
                pub_time: '2016-01-05',//公开日
                main_ipc: 'G06F17/27',//主IPC
                pub_type: '发明',//专利类型
                gr_no: null,//授权公告号
                pub_status_now: '实审',//当前状态
                applicant_name: [ '中国专利信息中心' ],//申请人
                inventor_name: [ '任智军', '谷威', '张威', '陈强', '范婷婷', '和兰', '谢慧', '张凯' ],//发明人
                pub_no: 'CN108255807A'//公开号
            }
        ] 
    },
    bizmsg: 'empty' 
}

```

## **<a name="paDetailsByfilingNo"> 根据申请号获取专利详情列表</a>**
[返回到目录](#menu)
##### URL
[/action/patentQuery/paDetailsByfilingNo]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`
#### 渠道执行的类型 actionType：paDetailsByfilingNo
``` javascript
{
"filingNo":"201711426233"
}

```

#### 返回结果
```javascript
{
    "status": 0,
    "msg": "操作成功",
    "data": {
        "total": 1,
        "data": [
            {
                "appl_zip": "510000",
                "agency_code": "44372",
                "filing_name": "一种访问网络的方法及网络设备、管理服务器",
                "filing_time": "2015-01-07",
                "main_ipc": "H04L29/06",
                "pub_type": "发明",
                "pub_status_now": "授权",
                "ipc_version": "(2006.01)",
                "agency_name": null,
                "other_ipc": [
                    "H04L29/06"
                ],
                "appl_address": "广东省广州市荔湾区中山八路6号1807房",
                "abstr_text": "本发明公开了一种访问网络的方法及网络设备、管理服务器,方法包括接收终端设备发送的域名查询请求报文,其中,域名查询请求报文携带终端设备所访问的目标网站的域名;向DNS服务器转发域名查询请求报文;接收DNS服务器返回的域名查询成功应答报文,其中,域名查询成功应答报文携带目标网站的域名对应的IP地址;将域名查询成功应答报文中携带的网站的域名对应的IP地址修改为管理服务器的IP地址;将修改后的域名查询成功应答报文返回给终端设备,以使终端设备向目标网站发送网页请求报文时,网页请求报文中所携带的目的IP地址为管理服务器的IP地址。通过上述方式,本发明能够管理终端设备与网络之间交互的数据报文。",
                "pct_info": {
                    "pct_pub_lang": "zh",
                    "inter_date": 1421298000,
                    "pct_filing_date": 1420606800,
                    "pct_pub_date": 1449723600,
                    "pct_filing_no": "PCT/CN2015/070285",
                    "pct_pub_no": "WO2015/184799"
                },
                "pub_time": "2015-04-08",
                "claim_text": "1.一种访问网络的方法,其特征在于,包括:接收网页请求报文,其中,所述网页请求报文包含目的IP地址、源IP地址和终端设备所?访问的目标网站的URL地址,所述目的IP地址为管理服务器的IP地址,所述源IP地址为终端?设备的IP地址;解析所述网页请求报文,根据所述网页请求报文中携带的URL地址向DNS服务器发送域?名查询请求报文,以请求所述目标网站的IP地址;接收所述DNS服务器返回的域名查询成功应答报文,其中,所述域名查询成功应答报文?携带所述目标网站的域名对应的IP地址;将所述网页请求报文中的目的IP地址修改为所述目标网站的IP地址,以及所述网页请?求报文中的源IP地址修改为管理服务器的IP地址,向所述目标网站发送网页请求并向所述?目标网站转发所述修改后的网页请求报文;接收所述目标网站根据所述修改后的网页请求报文返回的网页请求应答报文;将所述网页请求应答报文中目的IP地址修改为所述终端设备的IP地址,并向所述终端?设备转发所述网页请求应答报文。",
                "filing_no": "201580000001",
                "agent_name1": "张莉",
                "pub_status": "有效",
                "agent_name2": null,
                "applicant_name": [
                    "胡汉强"
                ],
                "country_code": "81",
                "img_path": "http://43.247.184.94:7170/Img/patent/china/FMZL/2015/80000/001/93b6aed0-4bf4-4d5e-9fd6-c3c4d7e3c4fc.gif",
                "gr_no": "CN104509066B",
                "gr_time": "2017-10-27",
                "inventor_name": [
                    "胡汉强"
                ],
                "prior_info": [
                    {
                        "pri_country": "CN",
                        "pri_date": 1401940800,
                        "pri_no": "2014102478520"
                    }
                ],
                "pub_no": "CN104509066A"
            }
        ]
    },
    "bizmsg": "empty",
    "requestId": "8242362615c341e0be659f32af02fa4b"
}

```

## **<a name="softwareCountByAuthor"> 根据公司名称得到软著量</a>**
[返回到目录](#menu)
##### URL
[/action/patentQuery/softwareCountByAuthor]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`
#### 渠道执行的类型 actionType：softwareCountByAuthor

``` javascript
{
"author":"中国专利信息中心"
}

```

#### 返回结果
```javascript
{ status: 0, msg: '操作成功', data: 5370, bizmsg: 'empty' }
```

## **<a name="softwareListByAuthor"> 根据公司名称得到软著详情</a>**
[返回到目录](#menu)
##### URL
[/action/patentQuery/softwareListByAuthor]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`
#### 渠道执行的类型 actionType：softwareListByAuthor

``` javascript
{
    "author":"",
    "page_size":10,
    "current_page":0
}

```

#### 返回结果
```javascript
{ 
    status: 0,
    msg: '操作成功',
    data:
    { 
        total: 5,
        data: 
        [ 
            { 
                reg_num: '2016SR348010',//登记号
                cat_num: '30200-8500',//分类号
                full_name: '美灵思(MLNX)慢性病管理系统服务器端软件',//软著名称
                simple_name: 'CDMS',//软件简称
                publish_time: 1470628800,//登记批准日期时间戳
                reg_time: 1480568400,//登记日期时间戳
                software_version: 'V1.0' //版本号
            }
        ] 
    },
    bizmsg: 'empty' 
}


```

## **<a name="softwareDetailsByregNum"> 根据登记号获取软著详情</a>**
[返回到目录](#menu)
##### URL
[/action/patentQuery/softwareDetailsByregNum]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`
#### 渠道执行的类型 actionType：softwareDetailsByregNum
``` javascript
{
	"reg_num": "2019SR0203965"
}

```

#### 返回结果
```javascript
{ 
    status: 0,
    msg: '操作成功',
    data:
    { 
        total: 5,
        data: 
        [ 
            { 
                reg_num: '2016SR348010',//登记号
                cat_num: '30200-8500',//分类号
                full_name: '美灵思(MLNX)慢性病管理系统服务器端软件',//软著名称
                simple_name: 'CDMS',//软件简称
                publish_time: 1470628800,//登记批准日期时间戳
                reg_time: 1480568400,//登记日期时间戳
                software_version: 'V1.0' //版本号
            }
        ] 
    },
    bizmsg: 'empty' 
}


```

## **<a name="worksCountByAuthor"> 根据公司名称得到著作权量</a>**
[返回到目录](#menu)
##### URL
[/action/patentQuery/worksCountByAuthor]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`
#### 渠道执行的类型 actionType：worksCountByAuthor

``` javascript
    {"author":""}

```

#### 返回结果
```javascript
{ status: 0, msg: '操作成功', data: 5370, bizmsg: 'empty' }

```

## **<a name="worksListByAuthor"> 根据公司名称得到著作权详情</a>**
[返回到目录](#menu)
##### URL
[/action/patentQuery/worksListByAuthor]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`
#### 渠道执行的类型 actionType：worksListByAuthor

``` javascript
{
    "author":"",
    "page_size":10,
    "current_page":0
}

```

#### 返回结果
```javascript
{ 
    status: 0,
    msg: '操作成功',
    data:
    { 
        total: 5,
        data: 
        [ 
            { 
                reg_num: '浙作登字-2017-F-00008752',//登记号
                works_name: '奖杯系列(6810)',//作品名称
                publish_time: 1500868800,//登记日期时间戳
                first_publish_time: null,//首次发布日期时间戳
                works_type: '美术',//类型 
                finish_time: 1496635200//创作完成日期时间戳
            }
        ] 
    },
    bizmsg: 'empty' 
}

```

## **<a name="worksDetailsByregNum"> 根据登记号获取著作权详情</a>**
[返回到目录](#menu)
##### URL
[/action/patentQuery/worksDetailsByregNum]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`
#### 渠道执行的类型 actionType：worksDetailsByregNum

``` javascript
{
  "reg_num": "1656"
}


```

#### 返回结果
```javascript
{ 
    status: 0,
    msg: '操作成功',
    data:
    { 
        total: 5,
        data: 
        [ 
            { 
                reg_num: '浙作登字-2017-F-00008752',//登记号
                works_name: '奖杯系列(6810)',//作品名称
                publish_time: 1500868800,//登记日期时间戳
                first_publish_time: null,//首次发布日期时间戳
                works_type: '美术',//类型 
                finish_time: 1496635200//创作完成日期时间戳
            }
        ] 
    },
    bizmsg: 'empty' 
}


```


## **<a name="CommomSearchbyTitle"> 根据标题查询聚合</a>**
[返回到目录](#menu)
##### URL
[/action/patentQuery/CommomSearchbyTitle]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`
#### 渠道执行的类型 actionType：CommomSearchbyTitle
```javascript

{
    "title": "一种基于有机物命名实体的机器翻译方法及翻译系统",//申请标题
    "pubtype": "发明",//专利类型：发明、实用新型、外观设计
    "pubstatus": "",//专利法律状态
    "filingyear": "",//申请年份
    "pubyear": "",//公开年份
    "pagesize": 20,
    "page": 1 
}
```
#### 返回结果

```javascript
{ status: 0,
  msg: '操作成功',
  data:
   { total: 5,
     max_score: 49.434937,
     hits: [ 
    {
    "_index": "bigdata_patent_bib",
    "_type": "_doc",
    "_id": "201410451887",
    "_score": 49.5767,
    "_source": {
        "pub_type": "发明",
        "gr_no": "CN104298662B",
        "filing_name": "一种基于有机物命名实体的机器翻译方法及翻译系统",
        "pub_time": "2015-01-21",
        "filing_time": "2014-09-05",
        "gr_time": "2017-10-10",
        "filing_no": "201410451887",
        "inventor_name": [
            "任智军",
            "张威",
            "李进",
            "杨婧",
            "张延花"
        ],
        "pub_status": "有效",
        "applicant_name": [
            "中国专利信息中心"
        ],
        "pub_no": "CN104298662A"
        }
    }
      
    ] },
  buckets:
   { group_by_pub_status:
      { doc_count_error_upper_bound: 0,
        sum_other_doc_count: 0,
        buckets: [
            {
                "key": "有效",
                "doc_count": 4
            },
            {
                "key": "在审",
                "doc_count": 1
            }
        ] 
    },
     group_by_filing_year:
      { doc_count_error_upper_bound: 0,
        sum_other_doc_count: 0,
        buckets: [
            {
                "key": "2017",
                "doc_count": 1
            },
            {
                "key": "2014",
                "doc_count": 2
            },
            {
                "key": "2013",
                "doc_count": 1
            },
            {
                "key": "2012",
                "doc_count": 1
            }
        ] 
    },
     group_by_pub_year:
      { doc_count_error_upper_bound: 0,
        sum_other_doc_count: 0,
        buckets: [
            {
                "key": "2018",
                "doc_count": 1
            },
            {
                "key": "2015",
                "doc_count": 1
            },
            {
                "key": "2014",
                "doc_count": 2
            },
            {
                "key": "2012",
                "doc_count": 1
            }
        ] 
    },
     group_by_pub_type:
      { doc_count_error_upper_bound: 0,
        sum_other_doc_count: 0,
        buckets: [
            {
                "key": "发明",
                "doc_count": 5
            }
        ]
    } 
   } 
}
```
## **<a name="CommomSearchbyFilingno"> 根据申请号查询聚合</a>**
[返回到目录](#menu)
##### URL
[/action/patentQuery/CommomSearchbyFilingno]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`
#### 渠道执行的类型 actionType：CommomSearchbyFilingno
```javascript
{
    "filingno": "201410451887",//申请号
    "pubtype": "发明",//专利类型：发明、实用新型、外观设计
    "pubstatus": "",//专利法律状态
    "filingyear": "",//申请年份
    "pubyear": "",//公开年份
    "pagesize": 20,
    "page": 1 
        
}

```
#### 返回结果
```javascript

{ status: 0,
  msg: '操作成功',
  data:
   { total: 5,
     max_score: 49.434937,
     hits: [ 
    {
    "_index": "bigdata_patent_bib",
    "_type": "_doc",
    "_id": "201410451887",
    "_score": 49.5767,
    "_source": {
        "pub_type": "发明",
        "gr_no": "CN104298662B",
        "filing_name": "一种基于有机物命名实体的机器翻译方法及翻译系统",
        "pub_time": "2015-01-21",
        "filing_time": "2014-09-05",
        "gr_time": "2017-10-10",
        "filing_no": "201410451887",
        "inventor_name": [
            "任智军",
            "张威",
            "李进",
            "杨婧",
            "张延花"
        ],
        "pub_status": "有效",
        "applicant_name": [
            "中国专利信息中心"
        ],
        "pub_no": "CN104298662A"
        }
    }
      
    ] },
  buckets:
   { group_by_pub_status:
      { doc_count_error_upper_bound: 0,
        sum_other_doc_count: 0,
        buckets: [
            {
                "key": "有效",
                "doc_count": 4
            },
            {
                "key": "在审",
                "doc_count": 1
            }
        ] 
    },
     group_by_filing_year:
      { doc_count_error_upper_bound: 0,
        sum_other_doc_count: 0,
        buckets: [
            {
                "key": "2017",
                "doc_count": 1
            },
            {
                "key": "2014",
                "doc_count": 2
            },
            {
                "key": "2013",
                "doc_count": 1
            },
            {
                "key": "2012",
                "doc_count": 1
            }
        ] 
    },
     group_by_pub_year:
      { doc_count_error_upper_bound: 0,
        sum_other_doc_count: 0,
        buckets: [
            {
                "key": "2018",
                "doc_count": 1
            },
            {
                "key": "2015",
                "doc_count": 1
            },
            {
                "key": "2014",
                "doc_count": 2
            },
            {
                "key": "2012",
                "doc_count": 1
            }
        ] 
    },
     group_by_pub_type:
      { doc_count_error_upper_bound: 0,
        sum_other_doc_count: 0,
        buckets: [
            {
                "key": "发明",
                "doc_count": 5
            }
        ]
    } 
   } 
}
```

## **<a name="CommomSearchbyPubno"> 根据公开号查询聚合</a>**
[返回到目录](#menu)
##### URL
[/action/patentQuery/CommomSearchbyPubno]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`
#### 渠道执行的类型 actionType：CommomSearchbyPubno
```javascript

{ 
    "pubno": "CN104298662A",//公开号
    "pubtype": "发明",//专利类型：发明、实用新型、外观设计
    "pubstatus": "",//专利法律状态
    "filingyear": "",//申请年份
    "pubyear": "",//公开年份
    "pagesize": 20,
    "page": 1 
}
```
#### 返回结果
```javascript

{ status: 0,
  msg: '操作成功',
  data:
   { total: 5,
     max_score: 49.434937,
     hits: [ 
    {
    "_index": "bigdata_patent_bib",
    "_type": "_doc",
    "_id": "201410451887",
    "_score": 49.5767,
    "_source": {
        "pub_type": "发明",
        "gr_no": "CN104298662B",
        "filing_name": "一种基于有机物命名实体的机器翻译方法及翻译系统",
        "pub_time": "2015-01-21",
        "filing_time": "2014-09-05",
        "gr_time": "2017-10-10",
        "filing_no": "201410451887",
        "inventor_name": [
            "任智军",
            "张威",
            "李进",
            "杨婧",
            "张延花"
        ],
        "pub_status": "有效",
        "applicant_name": [
            "中国专利信息中心"
        ],
        "pub_no": "CN104298662A"
        }
    }
      
    ] },
  buckets:
   { group_by_pub_status:
      { doc_count_error_upper_bound: 0,
        sum_other_doc_count: 0,
        buckets: [
            {
                "key": "有效",
                "doc_count": 4
            },
            {
                "key": "在审",
                "doc_count": 1
            }
        ] 
    },
     group_by_filing_year:
      { doc_count_error_upper_bound: 0,
        sum_other_doc_count: 0,
        buckets: [
            {
                "key": "2017",
                "doc_count": 1
            },
            {
                "key": "2014",
                "doc_count": 2
            },
            {
                "key": "2013",
                "doc_count": 1
            },
            {
                "key": "2012",
                "doc_count": 1
            }
        ] 
    },
     group_by_pub_year:
      { doc_count_error_upper_bound: 0,
        sum_other_doc_count: 0,
        buckets: [
            {
                "key": "2018",
                "doc_count": 1
            },
            {
                "key": "2015",
                "doc_count": 1
            },
            {
                "key": "2014",
                "doc_count": 2
            },
            {
                "key": "2012",
                "doc_count": 1
            }
        ] 
    },
     group_by_pub_type:
      { doc_count_error_upper_bound: 0,
        sum_other_doc_count: 0,
        buckets: [
            {
                "key": "发明",
                "doc_count": 5
            }
        ]
    } 
   } 
}
```
## **<a name="CommomSearchbyInventor"> 根据发明人查询聚合</a>**
[返回到目录](#menu)
##### URL
[/action/patentQuery/CommomSearchbyInventor]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`
#### 渠道执行的类型 actionType：CommomSearchbyInventor
```javascript

{
    "inventor": "任智军",//发明人
    "pubtype": "发明",//专利类型：发明、实用新型、外观设计
    "pubstatus": "",//专利法律状态
    "filingyear": "",//申请年份
    "pubyear": "",//公开年份
    "pagesize": 20,
    "page": 1 
}
```
#### 返回结果
```javascript

{ status: 0,
  msg: '操作成功',
  data:
   { total: 5,
     max_score: 49.434937,
     hits: [ 
    {
    "_index": "bigdata_patent_bib",
    "_type": "_doc",
    "_id": "201410451887",
    "_score": 49.5767,
    "_source": {
        "pub_type": "发明",
        "gr_no": "CN104298662B",
        "filing_name": "一种基于有机物命名实体的机器翻译方法及翻译系统",
        "pub_time": "2015-01-21",
        "filing_time": "2014-09-05",
        "gr_time": "2017-10-10",
        "filing_no": "201410451887",
        "inventor_name": [
            "任智军",
            "张威",
            "李进",
            "杨婧",
            "张延花"
        ],
        "pub_status": "有效",
        "applicant_name": [
            "中国专利信息中心"
        ],
        "pub_no": "CN104298662A"
        }
    }
      
    ] },
  buckets:
   { group_by_pub_status:
      { doc_count_error_upper_bound: 0,
        sum_other_doc_count: 0,
        buckets: [
            {
                "key": "有效",
                "doc_count": 4
            },
            {
                "key": "在审",
                "doc_count": 1
            }
        ] 
    },
     group_by_filing_year:
      { doc_count_error_upper_bound: 0,
        sum_other_doc_count: 0,
        buckets: [
            {
                "key": "2017",
                "doc_count": 1
            },
            {
                "key": "2014",
                "doc_count": 2
            },
            {
                "key": "2013",
                "doc_count": 1
            },
            {
                "key": "2012",
                "doc_count": 1
            }
        ] 
    },
     group_by_pub_year:
      { doc_count_error_upper_bound: 0,
        sum_other_doc_count: 0,
        buckets: [
            {
                "key": "2018",
                "doc_count": 1
            },
            {
                "key": "2015",
                "doc_count": 1
            },
            {
                "key": "2014",
                "doc_count": 2
            },
            {
                "key": "2012",
                "doc_count": 1
            }
        ] 
    },
     group_by_pub_type:
      { doc_count_error_upper_bound: 0,
        sum_other_doc_count: 0,
        buckets: [
            {
                "key": "发明",
                "doc_count": 5
            }
        ]
    } 
   } 
}

```
## **<a name="AffairsearchbyFilingno"> 根据申请号查询并根据法律状态日期排序</a>**
[返回到目录](#menu)
##### URL
[/action/patentQuery/AffairsearchbyFilingno]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`
#### 渠道执行的类型 actionType：AffairsearchbyFilingno
```javascript

{
   "filingno":"201410451887"//申请号
}
```
#### 返回结果
```javascript

{
	"status": 0,
	"msg": "操作成功",
	"data": {
		"total": 3,
		"max_score": null,
		"hits": [{
			"_index": "bigdata_patent_affair",
			"_type": "_doc",
			"_id": "24696710",
			"_score": null,
			"_source": {
				"filing_no": "201410451887",
				"aff_info": "公开",
				"aff_date": "2015-01-21",
				"aff_timestamp": 1421816400,
				"aff_status": "公开",
				"aff_code": "024000"
			},
			"sort": [1421798400000]
		}, {
			"_index": "bigdata_patent_affair",
			"_type": "_doc",
			"_id": "5523865",
			"_score": null,
			"_source": {
				"filing_no": "201410451887",
				"aff_info": "实质审查的生效",
				"aff_date": "2015-02-18",
				"aff_timestamp": 1424235600,
				"aff_status": "实质审查的生效",
				"aff_code": "001000"
			},
			"sort": [1424217600000]
		}, {
			"_index": "bigdata_patent_affair",
			"_type": "_doc",
			"_id": "41352716",
			"_score": null,
			"_source": {
				"filing_no": "201410451887",
				"aff_info": "授权",
				"aff_date": "2017-10-10",
				"aff_timestamp": 1507608000,
				"aff_status": "授权",
				"aff_code": "026000"
			},
			"sort": [1507593600000]
		}]
	},
	"bizmsg": "empty"
}

```
## **<a name="paDataOrderByPubno"> 查询所有专利，按公开日倒序排列</a>**
[返回到目录](#menu)
##### URL
[/action/patentQuery/paDataOrderByPubno]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`
#### 渠道执行的类型 actionType：paDataOrderByPubno
```javascript

{
   "page_size":10//需要返回的最大条数，可不传，默认20
   "current_page":0//需要返回的当前页。可不传，默认0
}
```
#### 返回结果
```javascript

{
	"status": 0,
	"msg": "操作成功",
	"data": {
		"total": 3,
		"data": [
            {
			    "abstr_text": "本申请提供了一种任务调度管理方法、装置及电子设备,其中,该任务调度管理方法包括:使用目标监测组件对容器编排平台中的目标工作进行监控;当目标监测组件监控到目标工作的工作状态发生变化时,则通过目标监测组件将目标工作的当前工作状态发送给任务记录组件;通过任务记录组件,根据目标工作的当前工作状态对目标工作对应的目标任务的任务状态进行更新。",
                "filing_name": "任务调度管理方法、装置及电子设备",
                "filing_no": "202010458650",
                "pub_no": "CN111597032A"
            }, 
            {
                "abstr_text": "本发明的一种基于WB芯片的双面挖腔陶瓷封装工艺,在陶瓷基板两侧面的芯片贴装位置进行预先挖腔,封装时将WB芯片分别沉到相应的陶瓷腔里并与陶瓷基板连接,连接后进行底面封帽和顶面封帽,在陶瓷基板底面焊接引脚并弯曲成型,完成封装。通过在陶瓷基板两侧面分别设置上挖腔和下挖腔,使得陶瓷基板的空间得到增大,且上挖腔和下挖腔内均设有WB芯片,使得陶瓷基板的封装空间变大,提高了陶瓷封装的空间利用率且降低了陶瓷封装的外形尺寸。",
                "filing_name": "一种基于WB芯片的双面挖腔陶瓷封装工艺",
                "filing_no": "202010458856",
                "pub_no": "CN111599689A"
            }, 
            {
				"abstr_text": "本发明公开了一种乐器打孔用定位装置,包括底板,所述底板的上表面上通过螺钉固定安装有伺服电缸,所述伺服电缸的输出端端头上通过螺钉固定安装有支撑板,所述支撑板的上表面上开设有圆槽,所述圆槽中通过至少四个连接机构转动安装有工作台,所述伺服电机的输出轴贯穿底板后与工作台固定连接,所述工作台的上表面左右边缘处均固定焊接有第一固定板,所述第一固定板上通过螺纹套管螺纹连接有手柄螺栓,所述手柄螺栓的端头上通过转动机构设置有活动夹块,所述第二固定板上固定焊接有固定夹块。本发明的高度可进行调节,可适应不同的打孔设备,可快速变换工作台的打孔工位,可实现连续性地打孔作业,提高了乐器加工效率。",
                "filing_name": "一种乐器打孔用定位装置",
                "filing_no": "202010459355",
                "pub_no": "CN111589936A"
		    }
	    ]
	},
	"bizmsg": "empty"
}

```