const CacheBase = require("../cache.base");
const system = require("../../system");
const settings = require("../../../config/settings");
const uuidv4 = require('uuid/v4');
class ApiAccessKeyClientCache extends CacheBase {
  constructor() {
    super();
    this.restS = system.getObject("util.restClient");
  }
  desc() {
    return "平台作为一个应用，缓存访问token";
  }
  prefix() {
    return "req_appkey_cachetoken:";
  }
  buildCacheVal(cachekey, inputkey, val, ex, ...items) {
    return JSON.stringify({ accessKey: val });
  }
}
module.exports = ApiAccessKeyClientCache;
