const Sequelize = require('sequelize');
const settings=require("../../../../config/settings")
const fs=require("fs")
const path=require("path");
var glob = require("glob");
class DbFactory{
  constructor(){
    const dbConfig=settings.database();
    this.db=new Sequelize(dbConfig.dbname,
                          dbConfig.user,
                          dbConfig.password,
                          dbConfig.config);
    this.db.Sequelize=Sequelize;
    this.db.Op=Sequelize.Op;
    this.initModels();
    this.initRelations();
  }
  async initModels(){
    var self=this;
    var modelpath=path.normalize(path.join(__dirname, '../..'))+"/models/";
    console.log("modelpath=====================================================");
    console.log(modelpath);
    var models=glob.sync(modelpath+"/**/*.js");
    console.log(models.length);
    models.forEach(function(m){
       console.log(m);
       self.db.import(m);
    });
    console.log("init models....");
  }
  async initRelations(){
     /**
       一个账户对应多个登陆用户
       一个账户对应一个commany
       一个APP对应多个登陆用户
       一个APP有多个角色
       登陆用户和角色多对多
     **/
     /*建立账户和用户之间的关系*/
     //account--不属于任何一个app,是统一用户
     //用户登录时首先按照用户名和密码检查account是否存在，如果不存在则提示账号或密码不对，如果
     //存在则按照按照accountid和应用key,查看user，后台实现对应user登录
     //管理员添加用户，需要同时增加开放平台用户及其所属租户创建的公司

     this.db.models.user.belongsTo(this.db.models.account,{constraints: false,});
     this.db.models.account.hasMany(this.db.models.user,{constraints: false,});

     this.db.models.user.belongsTo(this.db.models.company,{as:"owner",constraints: false,});//人员直属公司
     this.db.models.user.belongsTo(this.db.models.user,{as:"tanentor",constraints: false,});//指定用户所属租户

     this.db.models.app.belongsTo(this.db.models.user,{as:"creator",constraints: false,});//指定用户所属租户

    this.db.models.user.belongsTo(this.db.models.app,{constraints: false,});
    this.db.models.role.belongsTo(this.db.models.app,{constraints: false,});

    this.db.models.role.belongsTo(this.db.models.company,{constraints: false,});

    this.db.models.auth.belongsTo(this.db.models.app,{constraints: false,});
    this.db.models.auth.belongsTo(this.db.models.company,{constraints: false,});

    this.db.models.dataauth.belongsTo(this.db.models.app,{constraints: false,});
    this.db.models.dataauth.belongsTo(this.db.models.user,{constraints: false,});

    /*建立用户和角色之间的关系*/
    this.db.models.user.belongsToMany(this.db.models.role, {as:"Roles",through: 'p_userrole',constraints: false,});
    this.db.models.role.belongsToMany(this.db.models.user, {as:"Users",through: 'p_userrole',constraints: false,});

    this.db.models.pconfig.belongsTo(this.db.models.app,{constraints: false,});
    this.db.models.pconfig.belongsTo(this.db.models.company,{constraints: false,});

     /*建立应用和租户公司之间的关系*/
     this.db.models.company.belongsToMany(this.db.models.app, {through: this.db.models.companyapp,constraints: false,});
     this.db.models.app.belongsToMany(this.db.models.company, {through: this.db.models.companyapp,constraints: false,});

     /*建立用户和租户之间的关系*/
     this.db.models.user.belongsToMany(this.db.models.company, {through: this.db.models.usercompany,constraints: false,});
     this.db.models.company.belongsToMany(this.db.models.user, {through: this.db.models.usercompany,constraints: false,});

     /*组织机构*/
     this.db.models.org.belongsTo(this.db.models.org,{constraints: false,});
     this.db.models.org.hasMany(this.db.models.org,{constraints: false,});
     this.db.models.org.belongsTo(this.db.models.company,{constraints: false,});
     this.db.models.org.belongsTo(this.db.models.app,{constraints: false,});

     //组织机构和角色是多对多关系
     this.db.models.org.belongsToMany(this.db.models.role,{through: this.db.models.orgrole,constraints: false,});
     this.db.models.role.belongsToMany(this.db.models.org,{through: this.db.models.orgrole,constraints: false,});

     //组织机构和用户是多对多关系
     this.db.models.user.belongsTo(this.db.models.org,{constraints: false,});

  }
    //async getCon(){,用于使用替换table模型内字段数据使用
   getCon(){
    var that=this;
    // await this.db.authenticate().then(()=>{
    //   console.log('Connection has been established successfully.');
    // }).catch(err => {
    //   console.error('Unable to connect to the database:', err);
    //   throw err;
    // });
    //同步模型
    if(settings.env=="dev"){

      //console.log(pa);
      // pconfigObjs.forEach(p=>{
      //   console.log(p.get({plain:true}));
      // });
      // await this.db.models.user.create({nickName:"dev","description":"test user",openId:"testopenid",unionId:"testunionid"})
      // .then(function(user){
      //   var acc=that.db.models.account.build({unionId:"testunionid",nickName:"dev"});
      //   acc.save().then(a=>{
      //       user.setAccount(a);
      //   });
      // });
    }
    return this.db;
  }
  getConhb(){
   var that=this;
   if(settings.env=="dev"){
   }
   return this.dbhb;
 }
}
module.exports=DbFactory;
//  const dbf=new DbFactory();
// dbf.getCon().then((db)=>{
//   //console.log(db);
//   // db.models.user.create({nickName:"jy","description":"cccc",openId:"xxyy",unionId:"zz"})
//   // .then(function(user){
//   //   var acc=db.models.account.build({unionId:"zz",nickName:"jy"});
//   //   acc.save().then(a=>{
//   //       user.setAccount(a);
//   //   });
//   //   console.log(user);
//   // });
//   // db.models.user.findAll().then(function(rs){
//   //   console.log("xxxxyyyyyyyyyyyyyyyyy");
//   //   console.log(rs);
//   // })
// });
// const User = db.define('user', {
//     firstName: {
//       type: Sequelize.STRING
//     },
//     lastName: {
//       type: Sequelize.STRING
//     }
// });
// db
//   .authenticate()
//   .then(() => {
//       console.log('Co+nnection has been established successfully.');
//
//       User.sync(/*{force: true}*/).then(() => {
//         // Table created
//         return User.create({
//           firstName: 'John',
//           lastName: 'Hancock'
//         });
//       });
//
//   })
//   .catch(err => {
//     console.error('Unable to connect to the database:', err);
//   });
//
//   User.findAll().then((rows)=>{
//     console.log(rows[0].firstName);
//   });
