const system = require("../../../system");
const ServiceBase = require("../../sve.base");
const settings = require("../../../../config/settings");
const uiconfig = system.getUiConfig2(settings.appKey);
class CompanyService extends ServiceBase {
  constructor() {
    super("common", ServiceBase.getDaoName(CompanyService));
    this.userS=system.getObject("service.auth.userSve");
  }
  async create(p,user){
     var self=this;
     return this.db.transaction(async function (t){
        var company=await self.dao.model.create(p,{transaction:t});
        await user.addCompany(company,{transaction:t});
            //先按照用户id,取消所有当前
      var up1=await self.db.models.usercompany.update({isCurrent:false},{where:{user_id:user.id},transaction:t});
      //按照用户id和公司id,设置当前
      var up2=await self.db.models.usercompany.update({isCurrent:true},{where:{user_id:user.id,company_id:company.id},transaction:t});
        return company;
     });
  }
  async delete(pobj){
    var self=this;
    return this.db.transaction(async function (t){
      //查询出要删除的租户
      var usercomp=await self.db.models.usercompany.findOne({where:{user_id:pobj.userid,company_id:pobj.id}});
      await usercomp.destroy({where:{user_id:pobj.userid,company_id:pobj.id},transaction:t});
      //to 删除公司选择的应用
      await self.db.models.companyapp.destroy({where:{
        company_id:pobj.id
      },transaction:t});
       var rtn=await self.dao.delete({id:pobj.id},t);
       //按照公司ID，查询当前user表里是否有记录，如果已经有，就不要删除记录todo
       return rtn;
    });
  }
  async buyApp(p,cmid,user){
    var self=this;
    var appid=p.id;
    var cmid=cmid;
    return this.db.transaction(async function (t){
      //先按照用户id,取消所有当前
      // var cmp=await self.db.models.company.findOne({where:{
      //   id:cmid,
      //  }});
      //  cmp.addApp(p,{transaction:t});
     var seladd=await self.db.models.companyapp.create({
       company_id:cmid,
       app_id:appid
     },{transaction:t});
     //创建当前购买应用的管理员账号,设置所属公司，不需要建立公司关系在在中间表
     var appadminuser=await self.userS.createAdminUser({
       userName:user.userName,
       password:user.password,
       mobile:user.mobile,
       app_id:appid,
       owner_id:cmid,
       tanentor_id:user.id,//租户的id
     },{transaction:t});
     //查询当前公司，关联出apps
     var cmpfind=await self.db.models.company.findOne({where:{
            id:cmid,
        },
        include:[
          {model:self.db.models.app}
        ],
        transaction:t
      });
     return cmpfind;
   });
    
  }
  async settocompany(p){
    var self=this;
    var uid=p.userid;
    var cid=p.id;
    return this.db.transaction(async function (t){
       //先按照用户id,取消所有当前
      var up1=await self.db.models.usercompany.update({isCurrent:false},{where:{user_id:uid},transaction:t});
        //按照用户id和公司id,设置当前
      var up2=await self.db.models.usercompany.update({isCurrent:true},{where:{user_id:uid,company_id:cid},transaction:t});
      return p;
    });
 }
  async findAndCountAll(p,q,req){
    var u= await this.userS.dao.model.findOne({where:{id:p.userid},
    include: [
        {
          model: this.db.models.company,through:{attributes:['isCurrent']},include:[
             {model:this.db.models.app}
          ]
         
        },
      ]
    });
    var cmps=await u.companies;
    return cmps;
  }
}
module.exports = CompanyService;
