var system = require("../../../system")
var settings = require("../../../../config/settings");
const CtlBase = require("../../ctl.base");
var cacheBaseComp = null;

class FormInfoCtl extends CtlBase {
    constructor() {
        super("configmag", CtlBase.getServiceName(FormInfoCtl));
    }

    /**
     * 重写保存方法
     * @param pobj
     * @returns {Promise<void>}
     */
    async create(pobj){
        let result =  await this.service.createForm(pobj);
        return result;
    }

    /**
     * 重写添加方法
     * @param pobj
     * @returns {Promise<void>}
     */
    async update(pobj) {
        let result = await this.service.updateForm(pobj);
        return result;
    }

    /**
     * 复制表单
     * @returns {Promise<void>}
     */
    async copy(pobj){
        let result = await this.service.copy(pobj);
        return result;
    }

    /**
     * 删除
     * @param pobj
     * @returns {Promise<*>}
     */
    async delete(pobj){
        let result = await this.service.deleteForm(pobj);
        return result;
    }

    /**
     * 根据id获取表单
     * @param pobj
     * @returns {Promise<void>}
     */
    async findById(pobj){
        let result = await this.service.findOne({id:pobj.id},[]);
        return system.getResult(result);
    }

}

module.exports = FormInfoCtl;
