const system = require("../../../system");
const settings = require("../../../../config/settings");
// const fqBaseUrl="https://fq.gongsibao.com";//生产环境
const fqBaseUrl="https://fqdev.gongsibao.com";//测试环境
class FqUtilsService {
    constructor() {
        this.execClient = system.getObject("util.execClient");
        this.logClient = system.getObject("util.logClient");
    }

    async pushNeedInfo2Fq(pobj,code){
        try {
            var url = fqBaseUrl+"/open/ex/flux/advisory?code="+code;
            var rtn = await this.execClient.execPost(pobj, url);
            var data = JSON.parse(rtn.stdout);
            this.logClient.pushlog("测试数据---推送需求数据至蜂擎返回结果-pushNeedInfo2Fq-success",pobj, rtn, null);
            return data;
        } catch (e) {
            this.logClient.pushlog("测试数据---推送需求数据至蜂擎返回异常-pushNeedInfo2Fq-error", pobj, null, e.stack);
            return null;
        }
        

    }

}

module.exports = FqUtilsService;