const system = require("../../../system");
const ServiceBase = require("../../sve.base");
var settings = require("../../../../config/settings");
class NotarizationflowService extends ServiceBase {
  constructor() {
    super("transfer", ServiceBase.getDaoName(NotarizationflowService));
    this.tradetransferDao = system.getObject("db.transfer.tradetransferDao");
    this.aliclient = system.getObject("util.aliApiClient");
  }

  //公证信息推送阿里
  async setfiletoali(obj) {
    var uploadContext = {
      buyerData: {},
      sellerData: {},
      transferData: {}
    }
    //console.log(obj.sellerFrontOfIdCard.split("com//")[1]);
    obj.sellerFrontOfIdCard = buildurl(obj.sellerFrontOfIdCard)
    obj.sellerBackOfIdCard = buildurl(obj.sellerBackOfIdCard)
    obj.tmRegisterCertificate = buildurl(obj.tmRegisterCertificate)
    obj.businessLicense = buildurl(obj.businessLicense)
    obj.tmAcceptCertificate = buildurl(obj.tmAcceptCertificate)
    obj.buyerIdentification = buildurl(obj.buyerIdentification)
    obj.tmRegisterChangeCertificate = buildurl(obj.tmRegisterChangeCertificate)
    //买家信息   个人
    if (obj.buyerType == "person") {
      if (this.isStrEmpty(obj.buyerName) && this.isStrEmpty(obj.certificateNo) && this.isStrEmpty(obj.certificateType)) {
        uploadContext.buyerData = {
          buyerName: obj.buyerName,
          certificateNo: obj.certificateNo,
          certificateType: obj.certificateType
        }
      } else {
        return false;
      }
    } else {//买家信息   企业	
      if (this.isStrEmpty(obj.buyerCompanyName)) {
        uploadContext.buyerData = {
          buyerCompanyName: obj.buyerCompanyName
        }
      } else {
        return false;
      }
    }

    //卖家信息   个人
    if (obj.sellerType == "person") {
      if (this.isStrEmpty(obj.verifyPhone)
        && this.isStrEmpty(obj.phone)
        && this.isStrEmpty(obj.sellerFrontOfIdCard)
        && this.isStrEmpty(obj.sellerBackOfIdCard)
        && this.isStrEmpty(obj.buyerIdentification)
        && (this.isStrEmpty(obj.tmRegisterCertificate) || this.isStrEmpty(obj.tmAcceptCertificate) || this.isStrEmpty(obj.tmRegisterChangeCertificate))) {
        uploadContext.sellerData = {
          verifyPhone: obj.verifyPhone,
          phone: obj.phone
        };
        uploadContext.transferData = {
          sellerFrontOfIdCard: obj.sellerFrontOfIdCard,
          sellerBackOfIdCard: obj.sellerBackOfIdCard,
          buyerIdentification: obj.buyerIdentification,
          tmRegisterCertificate: obj.tmRegisterCertificate,
          tmAcceptCertificate: obj.tmAcceptCertificate,
          tmRegisterChangeCertificate: obj.tmRegisterChangeCertificate
        }
      } else {
        return false;
      }
    } else {//卖家信息   企业	
      if (this.isStrEmpty(obj.legalPersonPhone)
        && this.isStrEmpty(obj.companyContactName)
        && this.isStrEmpty(obj.verifyPhone)
        && this.isStrEmpty(obj.phone)
        && this.isStrEmpty(obj.businessLicenseId)
        && this.isStrEmpty(obj.sellerCompanyName)
        && this.isStrEmpty(obj.sellerCompanyAddress)
        && this.isStrEmpty(obj.legalPersonIdCard)
        && this.isStrEmpty(obj.companyContactPhone)
        && this.isStrEmpty(obj.legalPersonName)
        && this.isStrEmpty(obj.buyerIdentification)
        && this.isStrEmpty(obj.businessLicense)
        && (this.isStrEmpty(obj.tmRegisterCertificate) || this.isStrEmpty(obj.tmAcceptCertificate) || this.isStrEmpty(obj.tmRegisterChangeCertificate))) {
        uploadContext.sellerData = {
          legalPersonPhone: obj.legalPersonPhone,  // "法定代表人手机号", 
          companyContactName: obj.companyContactName,    // "企业联系人姓名，可以和法人姓名一致", 
          verifyPhone: obj.verifyPhone,    // "验证手机号",
          phone: obj.phone, // "手机号", 
          businessLicenseId: obj.businessLicenseId, // "统一社会信用代码（营业执照）", 
          sellerCompanyName: obj.sellerCompanyName,    // "企业名称", 
          sellerCompanyAddress: obj.sellerCompanyAddress,   // "卖方公司地址", 
          legalPersonIdCard: obj.legalPersonIdCard,  // "法定代表人身份证号码", 
          companyContactPhone: obj.companyContactPhone,    // "企业联系人电话，可以和法人手机号一致", 
          legalPersonName: obj.legalPersonName   // "法定代表人姓名"	
        },
          uploadContext.transferData = {
            sellerFrontOfIdCard: obj.sellerFrontOfIdCard,
            sellerBackOfIdCard: obj.sellerBackOfIdCard,
            tmRegisterCertificate: obj.tmRegisterCertificate,
            businessLicense: obj.businessLicense,
            tmAcceptCertificate: obj.tmAcceptCertificate,
            buyerIdentification: obj.buyerIdentification,
            tmRegisterChangeCertificate: obj.tmRegisterChangeCertificate
          }
      } else {
        return false;
      }
    }
    var source = {
      action: "UploadNotaryData",
      reqbody: {
        NotaryType: 1,
        BizOrderNo: obj.ali_bizid,
        UploadContext: JSON.stringify(uploadContext)
      }

    }
    console.log(source);
    var result = await this.aliclient(source);
    console.log(result);
    return result;
  }

  async selnotarytype(obj) {
    if (!obj.ali_bizid) {
      return {
        "errorCode": "error",
        "errorMsg": "ali_bizid不能为空",
        "module": { "orderNumber": "" },
        "requestId": obj.requestid,
        "success": false
      }
    }
    if (!obj.token) {
      return {
        "errorCode": "error",
        "errorMsg": "token不能为空",
        "module": { "orderNumber": "" },
        "requestId": obj.requestid,
        "success": false
      }
    }
    var source = {
      action: "ListNotaryInfos",
      reqbody: {
        NotaryType: 1,
        BizOrderNo: obj.ali_bizid,
        PageNum: 1,
        PageSize: 10,
        Token: obj.token
      }
    }
    var result = await this.aliclient(source);
    console.log(result);
    return result;
  }

  async firstload(obj) {
    var self = this;
    var traninfo = await this.tradetransferDao.findOne({ ali_bizid: obj.ali_bizid });
    if (traninfo.dataValues) {
      if (traninfo.dataValues.notarization_flow_id) {
        var notarinfo = await this.dao.findOne({ ali_bizid: obj.ali_bizid });
        if (notarinfo) {
          return { data: notarinfo.dataValues, status: 0, msg: "操作成功" }
        } else {
          return { data: null, status: -201, msg: "查询失败失败" }
        }
      } else {
        var source = {
          ali_bizid: traninfo.dataValues.ali_bizid,
          fq_ordernum: traninfo.dataValues.fq_ordernum,
          tmRegisterNo: traninfo.dataValues.tm_number,
          tmClassification: traninfo.dataValues.ncl_one
        }
        return this.db.transaction(async function (t) {
          var notarinfo = await self.dao.create(source, t);
          if (notarinfo) {
            traninfo.dataValues.notarization_flow_id = notarinfo.dataValues.id;
            await self.tradetransferDao.update(traninfo.dataValues);
            return { data: notarinfo.dataValues, status: 0, msg: "操作成功" }
          } else {
            return { data: null, status: -202, msg: "创建失败" }
          }
        })
      }
    } else {
      return { data: null, status: -200, msg: "参数异常" }
    }
  }

  async sellist() {
   var obj={
     
   }
  }
}
function buildurl(url){
  if (url && url.indexOf("com//") > -1){
    return url.split("com//")[1]
  }
  return url
}
module.exports = NotarizationflowService;
