var APIBase = require("../../api.base");
var system = require("../../../system");
var settings = require("../../../../config/settings");
class IcpAPI extends APIBase {
    constructor() {
        super();
        // this.utilsProductSve = system.getObject("service.utilsSve.utilsProductSve");
        this.centerorderSve = system.getObject("service.common.centerorderSve");
    }
    /**
      * 接口跳转-POST请求
      * action_process  执行的流程
      * action_type     执行的类型
      * action_body     执行的参数
      */
    async springBoard(pobj, qobj, req) {
        if (!pobj.actionType) {
            return system.getResult(null, "actionType参数不能为空");
        }
        if (pobj.actionType == 'getPolicyNeedList' || pobj.actionType == 'submitPolicyNeedNotes') {
            if (!pobj.userInfo) {
                return system.getResult(system.noLogin, "user no login!");
            }
            if (!pobj.appInfo) {
                return system.getResult(system.noLogin, "app is null!");
            }
        }
        var result = await this.opActionProcess(pobj, pobj.actionType, req);
        return result;
    }
    async opActionProcess(pobj, action_type, req) {
        var opResult = null;
        switch (action_type) {
            case "getNeedSolutionDetailByUser"://获取方案详情
                opResult = await this.centerorderSve.reqCenterOrderApi(pobj,"action/icpapi/springBoard");
                break;
            case "submitIcpProgramme"://icp方案提交
                opResult = await this.centerorderSve.submitIcpProgramme(pobj);
                break;
            case "submitIcpMaterial"://icp材料提交
                opResult = await this.centerorderSve.submitIcpMaterial(pobj);
                break;
            case "acceptIcpPartnerNotification"://icp通知状态变更
                opResult = await this.centerorderSve.acceptIcpPartnerNotification(pobj);
                break;
            case "abolishIcpProgramme"://服务商icp方案关闭
                opResult = await this.centerorderSve.abolishIcpProgramme(pobj);
                break;
            case "getProgrammeInfoByChannelNeedNo"://获取需求方案列表
                opResult = await this.centerorderSve.reqCenterOrderApi(pobj,"action/icpapi/springBoard");
                break;
            // case "updateStausByRefundOrder"://修改退款方案状态
            //     opResult = await this.needsolutionSve.updateStausByRefundOrder(pobj);
            //     break;
            default:
                opResult = system.getResult(null, "action_type参数错误");
                break;
        }
        return opResult;
    }

}
module.exports = IcpAPI;