//百度工商注册
var APIBase = require("../../api.base");
var system = require("../../../system");
const regCfg = require("./regCfg");

class Order extends APIBase {
    constructor() {
        super();
        this.gatewaypushlogSve = system.getObject("service.common.gatewaypushlogSve");
    }


    //状态变更
    async notify(pobj, req) {
        if (!pobj.appInfo || !pobj.appInfo.uapp_key || !pobj.appInfo.uapp_secret) {
            return regCfg.getResultFail("未知应用或应用未启用");
        }
        if (!pobj.isDirectBuy || pobj.isDirectBuy == 0) {
            pobj.isDirectBuy = 0;
        }
        if (!pobj.orderNo) {
            return regCfg.getResultFail("orderNo不能为空");
        }
        // var i = 0;
        // var orderLength = pobj.subOrderList.lenght;
        // for (i = 0; i <= orderLength; i++) {

        //     if (!pobj.subOrderList[i].orderNo) {
        //         return regCfg.getResultFail("orderNo不能为空");
        //     }
        //     if (pobj.isDirectBuy == 0 && !pobj.subOrderList[i].bizId) {
        //         return regCfg.getResultFail("非直接下单bizId不能为空");
        //     }
        //     if (pobj.isDirectBuy == 1 && !pobj.subOrderList[i].phone) {
        //         return regCfg.getResultFail("直接下单phone不能为空");
        //     }
        //     if (pobj.isDirectBuy == 1 && !pobj.subOrderList[i].consultType) {
        //         return regCfg.getResultFail("直接下单consultType不能为空");
        //     }
        //     // if (pobj.subOrderList[i].area) {
        //     //     pobj.subOrderList[i].area = regCfg.baiduArea[pobj.subOrderList[i].area]
        //     // }
        //     if (!pobj.subOrderList[i].area) {
        //         return regCfg.getResultFail("area参数错误");
        //     }
        // }
        if (!pobj.orderNo) {
            return regCfg.getResultFail("orderNo不能为空");
        }
        if (pobj.isDirectBuy==0 && !pobj.bizId) {
            return regCfg.getResultFail("非直接下单bizId不能为空");
        }
        if (pobj.isDirectBuy==1 && !pobj.phone) {
            return regCfg.getResultFail("直接下单phone不能为空");
        }
        if (pobj.isDirectBuy==1 && !pobj.consultType) {
            return regCfg.getResultFail("直接下单consultType不能为空");
        }
        if (pobj.area) {
            pobj.area = regCfg.baiduArea[pobj.area]
            }
        pobj.status = 1;
        pobj.action_type = "regOrderStatus";

        var param = {
            requestId: req.requestId || regCfg.getUUID(),
            requestUrl: "/ic/order/notify",
            requestjson: JSON.stringify(pobj),//请求地址
            pushUrl: "/action/intentionapi/springBoard",//调用地址
            pushActionType: "regOrderStatus",//调用参数
            pushtimes: 0,//推送次数
            pushStatus: "wts",//推送状态
        }
        await this.gatewaypushlogSve.create(param);
        return regCfg.getResultSuccess(param.requestId);
    }

    async close(pobj, req) {
        if (!pobj.appInfo || !pobj.appInfo.uapp_key || !pobj.appInfo.uapp_secret) {
            return regCfg.getResultFail("未知应用或应用未启用");
        }
        if (!pobj.orderNo) {
            return regCfg.getResultFail("orderNo不能为空");
        }
        pobj.channelOrderNo = pobj.orderNo;
        pobj.action_type = "regOrderClose";
        var param = {
            requestId: req.requestId || regCfg.getUUID(),
            requestUrl: "/ic/order/close",
            requestjson: JSON.stringify(pobj),//请求地址
            pushUrl: "/action/intentionapi/springBoard",//调用地址
            pushActionType: "regOrderClose",//调用参数
            pushtimes: 0,//推送次数
            pushStatus: "wts",//推送状态
        }
        await this.gatewaypushlogSve.create(param);
        return regCfg.getResultSuccess(param.requestId);
    }

}
module.exports = Order;