//百度配置
const uuidv4 = require('uuid/v4');
var  regCfg = {
    //工商注册城市对照表
    baiduArea : {
        "310100":"上海",	
        "441900":"东莞",
        "440600":"佛山",	
        "110100":"北京",	
        "320100":"南京",	
        "360100":"南昌",	
        "320600":"南通",	
        "331000":"台州",	
        "340100":"合肥",	
        "330400":"嘉兴",	
        "210200":"大连",	
        "120100":"天津",	
        "140100":"太原",	
        "330200":"宁波",	
        "320400":"常州",	
        "440100":"广州",	
        "320300":"徐州",	
        "510100":"成都",	
        "321000":"扬州",	
        "320200":"无锡",	
        "530100":"昆明",	
        "330100":"杭州",	
        "420100":"武汉",	
        "210100":"沈阳",	
        "370100":"济南",	
        "440300":"深圳",	
        "330300":"温州",	
        "370600":"烟台",	
        "350100":"福州",	
        "330600":"绍兴",	
        "320500":"苏州",	
        "610100":"西安",	
        "520100":"贵阳",	
        "410100":"郑州",	
        "500100":"重庆",	
        "330700":"金华",	
        "220100":"长春",	
        "430100":"长沙",	
        "370200":"青岛",
        "410200":"开封",
        "230100":"哈尔滨",
        "130100":"石家庄",
        "350200":"厦门",
        "360400":"九江",
        "410300":"洛阳",
        "411000":"许昌",
        "411600":"周口",
        "411300":"南阳",
        "420500":"宜昌",
        "420600":"襄阳",
        "430600":"岳阳",
        "430700":"常德",
        "440700":"江门",
        "440400":"珠海",
        "440900":"茂名",
        "441300":"惠州",
        "442000":"中山",
        "450100":"南宁",
        "460100":"海口",
        "460200":"三亚",
        "510700":"绵阳",
        "540100":"拉萨",
        "130600":"保定",
        "130200":"唐山",
        "140200":"大同",
        "1501":"呼和浩特"
    },

    baiduAreaCode : {
        "上海":	"310100",
        "东莞":	"441900",
        "佛山":	"440600",
        "北京":	"110100",
        "南京":	"320100",
        "南昌":	"360100",
        "南通":	"320600",
        "台州":	"331000",
        "合肥":	"340100",
        "嘉兴":	"330400",
        "大连":	"210200",
        "天津":	"120100",
        "太原":	"140100",
        "宁波":	"330200",
        "常州":	"320400",
        "广州":	"440100",
        "徐州":	"320300",
        "成都":	"510100",
        "扬州":	"321000",
        "无锡":	"320200",
        "昆明":	"530100",
        "杭州":	"330100",
        "武汉":	"420100",
        "沈阳":	"210100",
        "济南":	"370100",
        "深圳":	"440300",
        "温州":	"330300",
        "烟台":	"370600",
        "福州":	"350100",
        "绍兴":	"330600",
        "苏州":	"320500",
        "西安":	"610100",
        "贵阳":	"520100",
        "郑州":	"410100",
        "重庆":	"500100",
        "金华":	"330700",
        "长春":	"220100",
        "长沙":	"430100",
        "青岛":	"370200",
        "开封": "410200",
        "哈尔滨":"230100",
        "石家庄":"130100",
        "厦门":"350200",
        "九江":"360400",
        "洛阳":"410300",
        "许昌":"411000",
        "周口":"411600",
        "南阳":"411300",
        "宜昌":"420500",
        "襄阳":"420600",
        "岳阳":"430600",
        "常德":"430700",
        "江门":"440700",
        "珠海":"440400",
        "茂名":"440900",
        "惠州":"441300",
        "中山":"442000",
        "南宁":"450100",
        "海口":"460100",
        "三亚":"460200",
        "绵阳":"510700",
        "拉萨":"540100",
        "保定":"130600",
        "唐山":"130200",
        "大同":"140200",
        "呼和浩特":"150100"
      },
      channelTypeCode : {
        "GSREG" : "baidu.gsreg",
        "KZFW" : "baidu.kzfw",
        "GSCHANGS" : "baidu.gsbg",
        "GSNB" : "baidu.gsnb",
        "SKSQ" : "baidu.sksq",
        "SWBD" : "baidu.swbd"
      },
    //区分渠道的uappid
    uappId : {
        'baidu':44,
        'zhogxiaowei': 38
    },
    //交付状态
    deliverRegStatus:{
        'RECEIVED': 'RECEIVED',//已接单
        'COLLECTING': 'COLLECTING',//材料收集环节
        'AUDITING': 'AUDITING',//工商审核环节
        'ENGRAVING': 'ENGRAVING',//刻章环节
        'SUCCESS': 'SUCCESS', //已完成
        'ACTIVE': 'ACTIVE' //服务中
    },
     //交付状态
     deliverStatus:{
        'RECEIVED': '已接单',//
        'COLLECTING': '材料收集环节',//
        'AUDITING': '工商审核环节',//
        'ENGRAVING': '刻章环节',//
        'SUCCESS': '已完成', //
        'ACTIVE': '服务中' //
    },
    //返回结果配置
    getUUID() {
        var uuid = uuidv4();
        var u = uuid.replace(/\-/g, "");
        return u;
    },
    getResultSuccess(requestId) {
        return {
        "status": 0,
        "msg": "success",
        "data":null,
        "requestId": requestId
        };
    },
    getResultFail(errmsg) {
        return {
        "status":-1,
        "msg": errmsg,
        "requestId": this.getUUID(),
        "data":null,
        "bizmsg":"empty"
        };
    }
}
module.exports = regCfg;