var system = require("../../../system");
var settings = require("../../../../config/settings");
const AppServiceBase = require("../../app.base");
const fs = require("fs");
const { json } = require("sequelize");
const { getResult, getResultSuccess } = require("../../../system");
const { type } = require("os");
//区分渠道的uappid
const uappId = {
  'ali': 18,  //(阿里icp、edi)
  'baidu': 44,   //(百度icp、edi)
  'ename':52
}
//需求操作类----ali对接的需求
class UtilsNeedService2 extends AppServiceBase {
  constructor() {
    super();
    this.centerOrderUrl = settings.centerOrderUrl();
    this.utilsPushSve = system.getObject("service.utilsSve.utilsPushSve");
    this.aliclient = system.getObject("util.aliyunClient");
    this.utilsOrderSve = system.getObject("service.utilsSve.utilsOrderSve");
    this.qcCenterOrderSve = system.getObject("service.common.qcCenterOrderSve");

    this.baiduclient = system.getObject("util.baiduClient");
    //如果刷单需要兼容百度，则解开注释，将qcCenterOrderSve 改为 baseCenterOrderSve
    //this.baseCenterOrderSve = system.getObject("service.common.baseCenterOrderSve");
  }
  /**
   * icp关闭需求
   * @param {*} pobj
   * @param {*} actionBody
   */
  async needCloseIcp(pobj, actionBody) {
    console.log('guanbi icp xuqiu pobj+++', pobj)
    if (actionBody.uapp_id == uappId.ali) {
      if (!actionBody.channelNeedNo) {
        return system.getResult(null, "actionBody.channelNeedNo can not be empty，100395");
      }
      if (!actionBody.note) {
        return system.getResult(null, "actionBody.note can not be empty，100395");
      }
    }
    var self = this;
    pobj.actionBody.intentionBizId = pobj.actionBody.channelNeedNo;
    pobj.actionType = "abolishIcpProgrammeByNeed"
    var reqUrl = this.centerOrderUrl + "action/qcapi/springBoard";
    var result = await this.restPostUrl(pobj, reqUrl);
    this.logCtl.info({
      appid: pobj.appInfo ? pobj.appInfo.uapp_id || "" : "",
      appkey: pobj.appInfo ? pobj.appInfo.uapp_key || "" : "",
      requestId: pobj.requestId || "",
      op: "service/impl/utilsSve/utilsNeedSve.js/needCloseIcp",
      content: JSON.stringify(pobj),
      resultInfo: JSON.stringify(result),
      optitle: "abolishIcpProgrammeByNeed推送蜂擎获取的接口信息->aliBusiness2Delivery",
    });
    console.log('result close', result)
    if (result.status == 0) {
      if (result.data && result.data.orderNo) {
        pobj.actionBody.orderNo = result.data.orderNo;
        var orderrtn = await self.utilsOrderSve.delOrder(pobj, pobj.actionBody);
        if (orderrtn.status < 0) {
          return system.getResultFail(-5022, "订单关闭失败");
        }
      }

      //推送交付系统
      var reqParams = {
        actionBody: {
          intentionBizId: pobj.actionBody.channelNeedNo,
          status: "closeNeed"
        },
        opType: "updateChanceStatus",
        appInfo: pobj.appInfo
      }
      self.utilsPushSve.business2Channel(reqParams, "updateChanceStatus");
      //日志记录
      self.logCtl.info({
        appid: pobj.appInfo ? pobj.appInfo.uapp_id || "" : "",
        appkey: pobj.appInfo ? pobj.appInfo.uapp_key || "" : "",
        requestId: pobj.requestId || "",
        op: "service/impl/utilsSve/utilsNeedSve.js/needCloseIcp",
        content: JSON.stringify(reqParams),
        resultInfo: "",
        optitle: "updateChanceStatus推送蜂擎获取的接口信息->aliBusiness2Delivery",
      });
      // 推送ali
      if (result.data.uapp_id == uappId.ali) {
        var a = await self.aliclient.reqbyget({ action: "CloseIntention", reqbody: { BizId: actionBody.channelNeedNo, Note: actionBody.note }, apiVersion: "2019-05-08" });
      }
      // 推送baidu
      if (result.data.uapp_id == uappId.baidu) {
        var a = await self.baiduclient.baiduReqbyget({ path: "/api/bla/provider/requirement/update", reqbody: { requirementId: actionBody.channelNeedNo, status: "CLOSED", note: actionBody.note } });
      }
      console.log("closed need a+++", a);
      self.utilsPushSve.business2Channel(pobj, "pushCloseICPNeed");
    }
    return result;
  }

  async writeCommunicationLog(pobj) {
    if (!pobj.actionBody.intentionBizId) {
      return system.getResult(null, "actionBody.intentionBizId can not be empty，100491");
    }
    if (!pobj.actionBody.note) {
      return system.getResult(null, "actionBody.note can not be empty，100492");
    }
    var self = this;
    var reqUrl = this.centerOrderUrl + "action/need/springBoard";
    var result = await this.restPostUrl(pobj, reqUrl);
    //2020-10-28 laolan start 
    if (result && result.status == 0 && result.data) {
      if (result.data == uappId.ali) {
        var res = await self.aliclient.reqbyget({ action: "writeCommunicationLog", reqbody: { BizId: pobj.actionBody.intentionBizId, Note: pobj.actionBody.note }, apiVersion: "2019-05-08" });
        console.log("ali+res", res)
      }
      if (result.data == uappId.baidu) {
        var ress = await self.baiduclient.baiduReqbyget({ path: "/api/bla/provider/communication", reqbody: { requirementId: pobj.actionBody.intentionBizId, content: pobj.actionBody.note } });
        console.log("baidu+res", ress)
      }
      if (result.data == uappId.ename) {
        console.log('settings.enameClientUrl()+"WriteCommunicationLog"----',settings.enameClientUrl()+"WriteCommunicationLog")
        var resss = await self.execClient.execEnamePost({ IntentionBizId: pobj.actionBody.intentionBizId, Note: pobj.actionBody.note }, settings.enameClientUrl()+"WriteCommunicationLog");
        console.log("ename+resss", resss)
      }
    }

    //推送交付系统
    var reqParams = {
      actionBody: {
        intentionBizId: pobj.actionBody.intentionBizId,
        status: "followingUp"
      },
      opType: "updateChanceStatus",
      appInfo: pobj.appInfo
    }
    self.utilsPushSve.business2Channel(reqParams, "updateChanceStatus");
    var fqobj = {
      actionBody: {
        "bizId": pobj.actionBody.intentionBizId,
        "follow_date": (new Date()).toISOString(),
        "follow_content": pobj.actionBody.note
      },
      opType: "aliFollowup",
      appInfo: pobj.appInfo
    }
    self.utilsPushSve.business2Channel(fqobj, "aliFollowup");
    return system.getResultSuccess();
  }

  //2020-10-28 laolan start 
  async queryExpertApplyCommunicationLogs(pobj) {
    var reqUrl = this.centerOrderUrl + "action/need/springBoard";
    var result = await this.restPostUrl(pobj, reqUrl);
    console.log('jilu+++result++++1--', result)
    if (result && result.status == 0 && result.data && result.data.uapp_id) {
      if (result.data.uapp_id == uappId.ali) {
        var res = await this.aliclient.reqbyget({
          action: "QueryExpertApplyCommunicationLogs", reqbody: {
            BeginTime: pobj.actionBody.BeginTime ? pobj.actionBody.BeginTime : "",
            EndTime: pobj.actionBody.EndTime ? pobj.actionBody.EndTime : "",
            BizId: pobj.actionBody.intentionBizId,
            UserFeedBack: pobj.actionBody.userFeedBack,
            PageNum: pobj.actionBody.pageNum || 1,
            PageSize: pobj.actionBody.pageSize || 10,
          }, apiVersion: "2019-05-08"
        });
        for(var i=0;i<res.data.Data.length;i++){
          res.data.Data[i]['createTime'] = new Date(res.data.Data[i].CreateTime).toISOString()
          res.data.Data[i]['content'] = res.data.Data[i].Note
        }
      }

      if (result.data.uapp_id == uappId.baidu) {
        console.log("bbbbb++", pobj)
        var res = await this.baiduclient.baiduReqbyget({
          path: "/api/bla/provider/communication/list", reqbody: {
            beginTime: pobj.actionBody.BeginTime ? pobj.actionBody.BeginTime : "",
            endTime: pobj.actionBody.EndTime ? pobj.actionBody.EndTime : "",
            requirementId: pobj.actionBody.intentionBizId
          }
        });
        console.log('xxcc+++', res)
      }

      if (result.data.uapp_id == uappId.ename) {// yiming / ename
        console.log("queryExpertApplyCommunicationLogs---ename---pobj--", pobj)
        console.log('settings.enameClientUrl()+"queryExpertApplyCommunicationLogs"----',settings.enameClientUrl()+"queryExpertApplyCommunicationLogs")
        var res = await this.execClient.execEnamePost({
          BeginTime: pobj.actionBody.BeginTime ? pobj.actionBody.BeginTime : "",
          EndTime: pobj.actionBody.EndTime ? pobj.actionBody.EndTime : "",
          BizId: pobj.actionBody.intentionBizId,
          UserFeedBack: pobj.actionBody.userFeedBack || true,
          PageNum: pobj.actionBody.pageNum || 1,
          PageSize: pobj.actionBody.pageSize || 10,
        }, settings.enameClientUrl()+"queryExpertApplyCommunicationLogs");
        console.log('ename+++queryExpertApplyCommunicationLogs---res---', res)
      }
    }
    //判断易名是否有写接口
    if(res && res.stdout == ""){//先判断没有写接口的情况
      if(result && result.status == 0 && result.data && result.data.followContent){
        for (let i = 0; i < result.data.followContent.length; i++) {
          if(typeof(result.data.followContent[i]) == 'string'){
            if(result && result.data && result.data.followContent && (JSON.parse(result.data.followContent[i])[0].content).indexOf('提交方案') > -1){
              result.data.followContent.splice(i,1);
            }
          }
        }
        result.data['Data'] =  result.data.followContent;
      }
      return getResultSuccess(result);
    }else{//正常易名有查询沟通记录
      if(res && res.data && res.data.result){
        res.data['Data'] = res.data.result
      }
      return getResultSuccess(res);
    }
  }

  async queryCommunicationLog(pobj) {
    var reqUrl = this.centerOrderUrl + "action/need/springBoard";
    var result = await this.restPostUrl(pobj, reqUrl);
    if(result && result.data && result.data.followContent){
      return getResultSuccess(result.data.followContent);
    }else{
      return system.getResult(null, "未查到跟进记录　100500");
    }
  }
}

module.exports = UtilsNeedService2;