var childproc = require('child_process');
const util = require('util');
const exec = util.promisify(require('child_process').exec);
const uuidv4 = require('uuid/v4');
var settings = require("../../config/settings");
const querystring = require('querystring');
const axios = require('axios');
class ExecClient {
    constructor() {
        this.cmdPostPattern = "curl --user admines:adminGSBes. -k -H 'Content-type: application/json'  -d '{data}' {url}";
        this.cmdGetPattern = "curl -G -X GET '{url}'";
        this.cmdPushDataPostPattern = "curl -k -H 'Content-type: application/json' -H 'token:{tk}' -H 'request-id:{requestId}' -d '{data}' {url}";
        this.cmdFeishuGetPattern = "curl -X GET -k -H 'Content-Type: application/json' -H 'Authorization: {Authorization}' -d '{data}' {url} ";
        this.cmdFeishuPostPattern = "curl -k -H 'Content-type: application/json' -H 'Authorization: {Authorization}'  -d '{data}' {url}";
        //360
        this.cmd360PostPattern = "curl -u gongsibao:qPa4PsVsxbQ847i5pOKSmfPKrzRoNKqx -d '{data}' -X POST {url}"

        this.cmdBaiduPostPattern = "curl -k -H 'Content-type: application/json' -H 'Authorization: {Authorization}'  -d '{data}' {url}";

        this.cmdGetpatternToken = "curl -G -k  -H 'authorization:{token}' -d '{data}' {url}";

        //易名
        this.cmdEnamePostPattern = "curl -k -H 'Content-type: application/json'  -d '{data}' {url}";

    }
    getUUID() {
        var uuid = uuidv4();
        var u = uuid.replace(/\-/g, "");
        return u;
    }
    async exec(cmd) {
        //await后面表达式返回的promise对象， 是then的语法糖，await返回then函数的返回值
        //异常需要try/catch自己捕获或外部catch捕获
        var options = {
            maxBuffer: 1024 * 1024 * 20
        };
        const { stdout, stderr } = await exec(cmd, options);
        return { stdout, stderr };
    }


    async exec2(cmd) {
        return exec(cmd, { encoding: "base64" });
    }

    FetchPostCmd(subData, url) {
        var data = JSON.stringify(subData);
        var cmd = this.cmdPostPattern.replace(/\{data\}/g,
            data).replace(/\{url\}/g, url);
        console.log(cmd);
        return cmd;
    }
    FetchFeishuPostCmd(subData, url) {
        var data = JSON.stringify(subData);
        var cmd = this.cmdFeishuPostPattern.replace(/\{data\}/g,
            data).replace(/\{url\}/g, url).replace(/\{Authorization\}/g, "Bearer " + subData.token);
        console.log(cmd);
        return cmd;
    }
    FetchBaiduPostCmd(subData, url) {
        var data = JSON.stringify(subData.data);
        var cmd = this.cmdBaiduPostPattern.replace(/\{data\}/g,
            data).replace(/\{url\}/g, url).replace(/\{Authorization\}/g, subData.authorization);
        console.log(cmd);
        return cmd;
    }
    FetchEnamePostCmd(subData, url) {
        var data = JSON.stringify(subData);
        var cmd = this.cmdEnamePostPattern.replace(/\{data\}/g,
            data).replace(/\{url\}/g, url);
        console.log(cmd);
        return cmd;
    }

    FetchPushDataPostCmd(subData, url, token, requestId) {
        var requestId = requestId || this.getUUID();
        var data = JSON.stringify(subData);
        var cmd = this.cmdPushDataPostPattern.replace(/\{data\}/g,
            data).replace(/\{url\}/g, url).replace(/\{tk\}/g, token).replace(/\{requestId\}/g, requestId);
        console.log(cmd);
        return cmd;
    }
    async execPost(subData, url) {
        //本机windows curl json格式
        // if (settings.env == 'dev') {
        //     const rs = await axios.post(url, subData);
        //     const ret = {
        //         stdout: JSON.stringify(rs.data)
        //     }
        //     return ret;
        // }
        let cmd = this.FetchPostCmd(subData, url);
        var result = await this.exec(cmd);
        return result;
    }
    async execFeishuPost(subData, url) {
        let cmd = this.FetchFeishuPostCmd(subData, url);
        var result = await this.exec(cmd);
        return result;
    }
    async execBaiduPost(subData, url) {
        let cmd = this.FetchBaiduPostCmd(subData, url);
        var result = await this.exec(cmd);
        return result;
    }
    async execEnamePost(subData, url) {
        let cmd = this.FetchEnamePostCmd(subData, url);
        var result = await this.exec(cmd);
        return result;
    }
    async execPushDataPost(subData, url, token, requestId) {
        if (settings.env == 'dev') {
            axios.defaults.headers['token'] = token;
            // axios.defaults.headers['request-id'] = requestId;
            const rs = await axios.post(url, subData);
            const ret = {
                stdout: JSON.stringify(rs.data)
            }
            return ret;
        }
        let cmd = this.FetchPushDataPostCmd(subData, url, token, requestId);
        var options = {
            maxBuffer: 1024 * 1024 * 20
        };
        var result = await this.exec(cmd, options);
        return result;
    }
    async execPost2(subData, url) {
        let cmd = this.FetchPostCmd(subData, url);
        var result = await this.exec2(cmd);
        return result;
    }

    FetchGetCmd(subData, url) {
        var cmd = this.cmdGetPattern.replace(
            /\{data\}/g, subData).replace(/\{url\}/g, url);
        console.log(cmd);
        return cmd;
    }

    //飞书小程序GET请求
    FetchFeishuGetCmd(subData, url) {
        var cmd = this.cmdFeishuGetPattern.replace(
            /\{data\}/g, subData).replace(/\{url\}/g, url).replace(/\{Authorization\}/g, "Bearer " + subData.user_access_token);
        console.log(cmd);
        return cmd;
    }
    async execFeishuGet(subData, url) {
        let cmd = this.FetchFeishuGetCmd(subData, url);
        console.log(cmd);
        var result = await this.exec(cmd);
        return result;
    }
    async execGet(subData, url) {
        let cmd = this.FetchGetCmd(subData, url);
        console.log(cmd);
        var result = await this.exec(cmd);
        return result;
    }

    Fetch360PostCmd(subData, url) {
        var cmd = this.cmd360PostPattern.replace(
            /\{data\}/g, subData).replace(/\{url\}/g, url);
        console.log(cmd);
        return cmd;
    }

    async exec360GetToken(url) {
        const qs = require('qs')
        let obj = { "scope": "smart_business", "grant_type": "client_credentials" }
        if (settings.env == 'dev') {
            const rs = await axios({
                method: 'post',
                url: url,
                data: qs.stringify(obj),
                auth: {
                    username: "gongsibao",
                    password: "qPa4PsVsxbQ847i5pOKSmfPKrzRoNKqx"
                }
            })
            const ret = {
                stdout: JSON.stringify(rs.data)
            }
            return ret;
        }
        let cmd = this.Fetch360PostCmd(qs.stringify(obj), url);
        console.log(cmd);
        var result = await this.exec(cmd);
        return result;
    }

    async execGet2(subData, url) {
        let cmd = this.FetchGetCmd(subData, url);
        console.log(cmd);
        var result = await this.exec2(cmd);
        return result;
    }

    async execGetTimeOut(subData, url, timeOut = 5000) {
        //timeOut，单位是毫秒
        let cmd = this.FetchGetCmd(subData, url);
        var options = {
            timeout: timeOut,
        };
        const { stdout, stderr } = await exec(cmd, options);
        return { stdout, stderr };
    }

    // 带token的url请求
    async restGetWithHAuthorizationUrl(userToken, url, subData) {
        if (settings.env == 'dev') {
            axios.defaults.headers['authorization'] = userToken;
            const rs = await axios.get(url, { params: subData });
            const ret = {
                stdout: JSON.stringify(rs.data)
            }
            return ret;
        }
        var data = querystring.stringify(subData);
        let cmd = this.FetchrestGetWithHAuthorizationUrl(userToken, url, data);
        console.log(cmd, "cmd............");
        var result = await this.exec(cmd, {
            maxBuffer: 1024 * 1024 * 15
        });
        return result;
    }

    FetchrestGetWithHAuthorizationUrl(userToken, url, subData) {
        var cmd = this.cmdGetpatternToken.replace(/\{url\}/g, url).replace(/\{token\}/g, userToken).replace(
            /\{data\}/g, subData);
        return cmd;
    }
}

module.exports = ExecClient;
// var x=new RestClient();
// x.execGet("","http://www.163.com").then(function(r){
//   console.log(r.stdout);
//   console.log(r.stderr);
// });
