<a name="menu" href="/doc">返回主目录</a>

1. [下商标订单](#addOrder)
1. [下其他订单](#addOtherOrder)
1. [获取订单列表信息](#getOrderInfo)
1. [获取订单详情信息](#getOrderDetails)
1. [获取订单操作日志信息](#getOrderLogInfo)
1. [删除订单](#delOrder)
1. [渠道订单支付通知](#channelPayNotify)


## **<a name="addOrder"> 下商标订单</a>**
[返回到目录](#menu)
##### URL
[/web/opaction/order/springBoard]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`
#### 请求头中需要增加userpin（用户登录后的凭证）的值
#### 渠道执行的类型 actionType：addOrder

``` javascript
{
    "channelItemCode":"zzsbzc",// Y 产品的渠道编码
    "channelItemAppendName":"",// Y 填写的商标名称
    "payCode": "zzsbzc-1", // Y 支付价格code
    "quantity":1,// Y 购买数量
    "additions":{// N 附加购买项目
        "payCode": "zzsbzc-2", // Y 支付价格code
        "quantity":2// Y 购买数量
    },
    "totalSum":360,// Y 订单总金额---(商标自助注册计算格式：小于10项为产品价格，大于10项的小项数量在additions参数中进行传递)
    "payTotalSum":360,	// Y 订单付款总金额	 
    "notes": "订单备注信息",// N 订单备注
    "orderContact":{ // Y 订单联系人信息
        "contacts": "宋毅",// Y 联系人
        "mobile": "15010929368",// Y 联系人电话
        "email": "songyi@gongsibao.com",// Y 联系人邮箱
        "fax": ""// N 传真
    },       
    "channelOrder":{// Y 渠道订单信息，没有则填写{}
        "channelServiceNo":"",// N 服务单号（即渠道服务单号）
        "channelOrderNo":"",// N 服务订单号（即渠道服务订单号，格式为： XX1,XX2）
        "needNo":"",// N 需求单号（即渠道需求单号）  
        "payTime":"",// N 渠道需求单号支付时间
        "orderStatus":1,// N 渠道需求单号支付支付状态 1: 待付款, 2: 已付款
        "channelParams":""// N 渠道参数（自定义参数）
    },
    "deliveryData":{//Y 交付单信息
        "apply": {//申请信息
            "applyAddr": "上海市杨浦区国定路346号三楼0624室",//执照详细地址
            "applyArea": "",//申请区域--暂时没有用到
            "businessLicensePic": "https://gsb-zc.oss-cn-beijing.aliyuncs.com/zc_yyzz120315554031547442019316.jpg",//营业执照jpg地址
			"businessLicensePdf": "https://gsb-zc.oss-cn-beijing.aliyuncs.com/zc_yyzz120315554031547442019316.pdf",//营业执照pdf地址
            "code": "91310110398635929J",//统一社会信用代码
            "customerType": "ent",//申请人类型 person个人，ent企业           
            "identityCardNo": "",//申请人身份证号--（申请类型为个人有此值）
            "identityCardPic": "",//申请人身份证jpg地址--（申请类型为个人有此值）
			"identityCardPdf": "",   //申请人身份证pdf地址  --（申请类型为个人有此值）    
            "name": "上海辰者信息科技有限公司",  //申请人名称          
            "gzwtsUrl": "https://gsb-zc.oss-cn-beijing.aliyuncs.com/zc_wts863215710393842862019914.jpg",//盖章委托书url
            "smwjUrl":"",//说明文件url
            "zipCode": "100000"//邮政编码
        },
        "tm": {
            "colorizedPicUrl": "https://gsb-zc.oss-cn-beijing.aliyuncs.com/zc_word2picb2bc98b9fc564ef2a1f4b3cbe9352f39.jpg",//商标彩色图样
            "tmName": "testbiao",//商标名称
            "picUrl": "https://gsb-zc.oss-cn-beijing.aliyuncs.com/zc_word2picb2bc98b9fc564ef2a1f4b3cbe9352f39.jpg",//商标图样       
            "tmFormType": "3"//商标类型形式： "3": 字, "4": 图, "5": 字图
        },
        tmSelectType:{ // N商标类别选择 没有则填写{}
            "selectType":"自助选择", //Y 商标类别选择  智能选择||自助选择||全类保护
            "recommendPath":"" //N 商标类别选择是只能选择的时候保存行业信息  人工智能/技术研究
        },
        "nclones": [
            {
                "code": "02",//大类编码
                "name": "颜料油漆",//大类名称
                "nclThree": [
                    {
                        "code": "020008",//小项编码
                        "disabled": "false",
                        "fullname": "020008 绘画用铝粉",//小项编码加名称
                        "name": "绘画用铝粉",//小项名称
                        "pcode": "0202"//小项所属群组编码
                    },
                    {
                        "code": "020005",
                        "disabled": "false",
                        "fullname": "020005 食品用着色剂",
                        "name": "食品用着色剂",
                        "pcode": "0203"
                    }
                ]
            }
        ]
    }
}

```

#### 返回结果
```javascript
{
    "status": 0,// 0为成功，否则失败
    "msg": "success",
    "data": {
        "orderNo": "OT26202002151649kPgs",//订单号
        "channelServiceNo": "OT26202002151649kPgs",//渠道服务单号
        "channelOrderNo"："OT26202002151649kPgs", //渠道订单号
        "channelParams": ""//渠道参数
    },
    "requestId": "2f90fad8108b4933bb97c3d978b0fe10"
}
```

## **<a name="addOtherOrder"> 下其他订单</a>**
[返回到目录](#menu)
##### URL
[/web/opaction/order/springBoard]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`
#### 请求头中需要增加userpin（用户登录后的凭证）的值
#### 渠道执行的类型 actionType：addOrder

``` javascript
{
    "channelItemCode":"fzsbzc",// Y 产品的渠道编码
    "payCode": "fzsbzc-1", // Y 支付价格code
    "quantity":1,// Y 购买数量
    "totalSum":699,// Y 订单总金额
    "payTotalSum":699,	// Y 订单付款总金额	 
    "notes": "订单备注信息",// N 订单备注
    "orderContact":{ // N 订单联系人信息，没有则填写{}
        "contacts": "宋毅",// N 联系人
        "mobile": "15010929368",// N 联系人电话
        "email": "songyi@gongsibao.com"// N 联系人邮箱			        
    },       
    "channelOrder":{// Y 渠道订单信息，没有则填写{}
        "channelServiceNo":"",// N 服务单号（即渠道服务单号）
        "channelOrderNo":"",// N 服务订单号（即渠道服务订单号，格式为： XX1,XX2）
        "needNo":"",// N 需求单号（即渠道需求单号）  
        "payTime":"",// N 渠道需求单号支付时间
        "orderStatus":1,// N 渠道需求单号支付支付状态 1: 待付款, 2: 已付款
        "channelParams":""// N 渠道参数（自定义参数）
    },
    "deliveryData":{}//Y 交付单信息，没有则填写{}
}

```

#### 返回结果
```javascript
{
    "status": 0,// 0为成功，否则失败
    "msg": "success",
    "data": {
        "orderNo": "OT26202002151649kPgs",//订单号
        "channelServiceNo": "OT26202002151649kPgs",//渠道服务单号
        "channelOrderNo"："OT26202002151649kPgs", //渠道订单号
        "channelParams": ""//渠道参数
    },
    "requestId": "2f90fad8108b4933bb97c3d978b0fe10"
}
```

## **<a name="getOrderInfo"> 获取订单列表信息</a>**
[返回到目录](#menu)
##### URL
[/web/opaction/order/springBoard]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`
#### 请求头中需要增加userpin（用户登录后的凭证）的值
#### 渠道执行的类型 actionType：getOrderInfo


``` javascript
{  
    "pageIndex":1,// Y 当前页{   
    "pageSize":20,// Y 每页大小，最大为50
    "channelItemName":"",// N 产品名称
    "channelServiceNo":"",// N 渠道订单号
    "orderStatus":"",// N 订单状态
    "startTime": "2019-10-27",// N 开始时间
    "entTime": "2019-10-31",// N 结束时间
    "typeCode":"gsfu" //N 大类code
}

```

#### 返回结果
```javascript
{
    "status": 0,// 0为成功，否则失败
    "msg": "success",
    "dataCount":2,//总条数
    "data": [
        {
            "orderNo": "OT31202002191443AVlJ",// 订单号
            "channelServiceNo": "",//渠道服务号
            "channelOrderNo": "",//渠道订单号列表，格式：XX1,XX2
            "channelUserId": "15010929366",//渠道用户Id
            "ownerUserId": "15010929366",//拥有者Id
            "payTime": null,//支付时间
            "quantity": 1,//订单数量
            "serviceQuantity": 0,//订单服务数量
            "orderStatusName": "待付款",//订单状态名称
            "orderStatus": 1,//订单状态编码: 1: 待付款, 2: 已付款, 4: 服务中, 8: 已完成
            "totalSum": "10.00",//订单金额
            "payTotalSum": "10.00",//订单支付金额
            "refundSum": "0.00",//退款金额
            "invoiceApplyStatus": "00",//发票申请状态
            "opNotes": "",//操作备注
            "channelItemCode": "FW_GOODS-582221-1",//渠道产品编码
            "channelItemName": "京东云PLUS公司注册（北京市）",//渠道产品名称
            "channelItemAppendName": "北京海淀",//渠道产品附加名称
            "price":"10.00",//产品单价
            "priceTypeName":"件",//产品单价单位名称
            "priceDesc":"海淀区内资一般人",//产品单价描述            
            "serviceItemCode": null,//服务产品编码
            "picUrl": null,//产品图片地址
            "created_at":""//下单时间
        },
        {
            "orderNo": "OT31202002191456tDU7",
            "channelServiceNo": "0001",
            "channelOrderNo": "",
            "channelUserId": "15010929366",
            "ownerUserId": "15010929366",
            "payTime": "2020",
            "quantity": 1,
            "serviceQuantity": 0,
            "orderStatusName": "已付款",
            "orderStatus": 2,
            "totalSum": "10.00",
            "payTotalSum": "10.00",
            "refundSum": "0.00",
            "invoiceApplyStatus": "00",
            "opNotes": "",
            "channelItemCode": "FW_GOODS-582221-1",
            "channelItemName": "京东云PLUS公司注册（北京市）",
            "channelItemAppendName": "",
            "price":"10.00",
            "priceTypeName":"件",
            "priceDesc":"海淀区内资一般人",
            "serviceItemCode": null,
            "picUrl": null,
            "created_at":""
        }
    ],
    "requestId": "92ced0cb4d地址cb4125a4b515227f3eabe1"
}

```

## **<a name="getOrderDetails"> 获取订单详情信息</a>**
[返回到目录](#menu)
##### URL
[/web/opaction/order/springBoard]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`
#### 请求头中需要增加userpin（用户登录后的凭证）的值
#### 渠道执行的类型 actionType：getOrderDetails


``` javascript
{  
    "orderNo":"TM26202002271337mkgN"// Y 订单号
}

```

#### 返回结果
```javascript
{
    "status": 0,// 0为成功，否则失败
    "msg": "success",
    "data": {
            "orderNo": "OT31202002191443AVlJ",// 订单号
            "channelServiceNo": "",//渠道服务号
            "channelOrderNo": "",//渠道订单号列表，格式：XX1,XX2
            "channelUserId": "15010929366",//渠道用户Id
            "ownerUserId": "15010929366",//拥有者Id
            "payTime": null,//支付时间
            "quantity": 1,//订单数量
            "serviceQuantity": 0,//订单服务数量
            "orderStatusName": "待付款",//订单状态名称
            "orderStatus": 1,//订单状态编码: 1: 待付款, 2: 已付款, 4: 服务中, 8: 已完成
            "totalSum": "10.00",//订单金额
            "payTotalSum": "10.00",//订单支付金额
            "refundSum": "0.00",//退款金额
            "invoiceApplyStatus": "00",//发票申请状态
            "opNotes": "",//操作备注
            "channelItemCode": "FW_GOODS-582221-1",//渠道产品编码
            "channelItemName": "京东云PLUS公司注册（北京市）",//渠道产品名称
            "channelItemAppendName": "北京海淀",//渠道产品附加名称
            "price":"10.00",//产品单价
            "priceTypeName":"件",//产品单价单位名称
            "priceDesc":"海淀区内资一般人",//产品单价描述            
            "serviceItemCode": null,//服务产品编码
            "picUrl": null,//产品图片地址
            "created_at":""//下单时间
        },
    "requestId": "92ced0cb4d地址cb4125a4b515227f3eabe1"
}

```

## **<a name="getOrderLogInfo"> 获取订单操作日志信息</a>**
[返回到目录](#menu)
##### URL
[/web/opaction/order/springBoard]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`
#### 请求头中需要增加userpin（用户登录后的凭证）的值
#### 渠道执行的类型 actionType：getOrderLogInfo


``` javascript
{  
    "sourceOrderNo":"TM26202002271337mkgN"// Y 订单号
}

```

#### 返回结果
```javascript
{
    "status": 0,// 0为成功，否则失败
    "msg": "success",
    "data": [
        {
            "opContent": "您的订单成功支付，请等待服务人员联系您",// 内容
            "created_at": "2020-02-28T18:45:44.000Z"//创建时间
        },
        {
            "opContent": "您提交了订单，请及时支付",
            "created_at": "2020-02-25T18:44:45.000Z"
        }
    ],
    "requestId": "f21446617c5e46ad889f3fab7bb69456"
}

```

## **<a name="delOrder"> 删除订单</a>**
[返回到目录](#menu)
##### URL
[/web/opaction/order/springBoard]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`
#### 请求头中需要增加userpin（用户登录后的凭证）的值
#### 渠道执行的类型 actionType：delOrder


``` javascript
{  
    "orderNo":"TM26202002271337mkgN"// Y 订单号
}

```

#### 返回结果
```javascript
{
    "status": 0,// 0为成功，否则失败
    "msg": "success",
    "data":null,
    "requestId": "f21446617c5e46ad889f3fab7bb69456"
}

```

## **<a name="channelPayNotify"> 渠道订单支付通知</a>**
[返回到目录](#menu)
##### URL
[/orderNotify/channelPayNotify]
#### 参数格式  `JSON`
#### HTTP请求方式 `POST`
#### signature方式：md5(appkey+orderNo+payTotalSum+secret),secret是申请的密钥


``` javascript
{  
    "appkey":"202001170336",// Y appkey
    "orderNo":"TM26202002271337mkgN",// Y 订单号
    "payTotalSum":300.00,// Y 订单金额
    "signature":"DC18F27EFC1A251AFC5F2FCF36ABE6FA",
    "payType":"", //支付方式 wx alipay
    "payTime":"",// 支付时间
    "payOrderNo":""// 支付订单流水号
}

```

#### 返回结果
```javascript
{
    "status": 0,// 0为成功，否则失败
    "msg": "success",
    "data":null,
    "requestId": "f21446617c5e46ad889f3fab7bb69456"
}

```