var APIBase = require("../../api.base");
var system = require("../../../system");
var settings = require("../../../../config/settings");
class LogoOrderAPI extends APIBase {
    constructor() {
        super();
        this.centerorderSve = system.getObject("service.common.centerorderSve");
    }
    /**
      * 接口跳转-POST请求
      * action_process  执行的流程
      * action_type     执行的类型
      * action_body     执行的参数
      */
    async springBoard(pobj, qobj, req) {
        if (!pobj.actionType) {
            return system.getResult(null, "actionType参数不能为空");
        }
        if (pobj.actionType == 'getPolicyNeedList' || pobj.actionType == 'submitPolicyNeedNotes') {
            if (!pobj.userInfo) {
                return system.getResult(system.noLogin, "user no login!");
            }
            if (!pobj.appInfo) {
                return system.getResult(system.noLogin, "app is null!");
            }
        }
        var result = await this.opActionProcess(pobj, pobj.actionType, req);
        return result;
    }
    async opActionProcess(pobj, action_type, req) {
        var opResult = null;
        switch (action_type) {
            case "singlelogo"://生成logo
                opResult = await this.centerorderSve.singlelogo(pobj);
                break;
            case "changelogo"://换一批logo
                opResult = await this.centerorderSve.changelogo(pobj);
                break;
            case "downloadlogoscene"://下载logo场景
                opResult = await this.centerorderSve.downloadlogoscene(pobj);
                break;
            case "getPaidLogoListByUser"://获取已购买的logo
                opResult = await this.centerorderSve.reqCenterOrderApi(pobj,"action/logoOrderApi/springBoard");
                break;
            case "getLogoMaterial"://下载logo素材
                opResult = await this.centerorderSve.reqCenterOrderApi(pobj,"action/logoOrderApi/springBoard");
                break;
            case "getCollectibleLogoListByUser"://获取收藏的logo
                opResult = await this.centerorderSve.reqCenterOrderApi(pobj,"action/logoOrderApi/springBoard");
                break;
            case "collectLogo"://收藏logo
                opResult = await this.centerorderSve.reqCenterOrderApi(pobj,"action/logoOrderApi/springBoard");
                break;
            case "cancelCollectLogo"://取消收藏
                opResult = await this.centerorderSve.reqCenterOrderApi(pobj,"action/logoOrderApi/springBoard");
                break;
            default:
                opResult = system.getResult(null, "action_type参数错误");
                break;
        }
        return opResult;
    }

}
module.exports = LogoOrderAPI;